/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.draftv4;

import java.util.EnumSet;
import java.util.HashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.helpers.DependenciesSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class DraftV4DependenciesSyntaxChecker
extends DependenciesSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4DependenciesSyntaxChecker() {
        super(NodeType.ARRAY);
    }

    @Override
    protected void checkDependency(ProcessingReport report, String name, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(name);
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.ARRAY) {
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_DEPENDENCY_VALUE).put("property", name).put("expected", this.dependencyTypes).put("found", type));
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY).put("property", name));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap(element));
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("property", name).put("index", index).put("expected", EnumSet.of(NodeType.STRING)).put("found", type));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE).put("property", name));
        }
    }
}

