/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.helpers;

import java.math.BigDecimal;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public abstract class NumericDigester
extends AbstractDigester {
    protected NumericDigester(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    private static boolean valueIsLong(JsonNode node) {
        if (!node.canConvertToLong()) {
            return false;
        }
        if (NodeType.getNodeType(node) == NodeType.INTEGER) {
            return true;
        }
        return node.decimalValue().remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    protected final ObjectNode digestedNumberNode(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        JsonNode node = schema.get(this.keyword);
        boolean isLong = NumericDigester.valueIsLong(node);
        ret.put("valueIsLong", isLong);
        if (isLong) {
            ret.put(this.keyword, node.canConvertToInt() ? FACTORY.numberNode(node.intValue()) : FACTORY.numberNode(node.longValue()));
            return ret;
        }
        BigDecimal decimal = node.decimalValue();
        ret.put(this.keyword, decimal.scale() == 0 ? FACTORY.numberNode(decimal.toBigIntegerExact()) : node);
        return ret;
    }
}

