/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.MissingNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.JsonReferenceException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonNodeResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.ReferenceToken;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.TokenResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.TreePointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.JsonReferenceErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;

@Immutable
public final class JsonPointer
extends TreePointer<JsonNode> {
    private static final JsonPointer EMPTY = new JsonPointer((List<TokenResolver<JsonNode>>)ImmutableList.<TokenResolver<JsonNode>>of());

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer of(Object first, Object ... other) {
        ArrayList<ReferenceToken> tokens = Lists.newArrayList();
        tokens.add(ReferenceToken.fromRaw(first.toString()));
        for (Object o : other) {
            tokens.add(ReferenceToken.fromRaw(o.toString()));
        }
        return new JsonPointer(JsonPointer.fromTokens(tokens));
    }

    public JsonPointer(String input) throws JsonReferenceException {
        this(JsonPointer.fromTokens(JsonPointer.tokensFromInput(input)));
    }

    private JsonPointer(List<TokenResolver<JsonNode>> tokenResolvers) {
        super(MissingNode.getInstance(), tokenResolvers);
    }

    public JsonPointer append(String raw) {
        ReferenceToken refToken = ReferenceToken.fromRaw(raw);
        JsonNodeResolver resolver = new JsonNodeResolver(refToken);
        ArrayList<TokenResolver<JsonNode>> list = Lists.newArrayList(this.tokenResolvers);
        list.add(resolver);
        return new JsonPointer((List<TokenResolver<JsonNode>>)list);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    public JsonPointer append(JsonPointer other) {
        if (other == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_JSON_POINTER));
        }
        ArrayList<TokenResolver<JsonNode>> list = Lists.newArrayList(this.tokenResolvers);
        list.addAll(other.tokenResolvers);
        return new JsonPointer((List<TokenResolver<JsonNode>>)list);
    }

    private static List<TokenResolver<JsonNode>> fromTokens(List<ReferenceToken> tokens) {
        ArrayList<TokenResolver<JsonNode>> list = Lists.newArrayList();
        for (ReferenceToken token : tokens) {
            list.add(new JsonNodeResolver(token));
        }
        return list;
    }
}

