/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples;

import java.io.IOException;
import java.util.UUID;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples.ExampleBase;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.DraftV4Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class Example8
extends ExampleBase {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Example8.loadResource("/custom-fmt.json");
        JsonNode good = Example8.loadResource("/custom-fmt-good.json");
        JsonNode bad = Example8.loadResource("/custom-fmt-bad.json");
        Library library = DraftV4Library.get().thaw().addFormatAttribute("uuid", UUIDFormatAttribute.getInstance()).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        Example8.printReport(report);
        report = schema.validate(bad);
        Example8.printReport(report);
    }

    private static final class UUIDFormatAttribute
    extends AbstractFormatAttribute {
        private static final FormatAttribute INSTANCE = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super("uuid", NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return INSTANCE;
        }

        @Override
        public void validate(ProcessingReport report, FullData data) throws ProcessingException {
            String value = data.getInstance().getNode().textValue();
            try {
                UUID.fromString(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.newMsg(data, "input is not a valid UUID").put("input", value));
            }
        }
    }
}

