/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg;

import java.net.URI;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfigurationBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.Dereferencing;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.URIDownloader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.Frozen;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableMap;

public final class LoadingConfiguration
implements Frozen<LoadingConfigurationBuilder> {
    final Dictionary<URIDownloader> downloaders;
    final URI namespace;
    final boolean enableCache;
    final Dereferencing dereferencing;
    final Map<URI, URI> schemaRedirects;
    final Map<URI, JsonNode> preloadedSchemas;

    public static LoadingConfigurationBuilder newBuilder() {
        return new LoadingConfigurationBuilder();
    }

    public static LoadingConfiguration byDefault() {
        return new LoadingConfigurationBuilder().freeze();
    }

    LoadingConfiguration(LoadingConfigurationBuilder cfg) {
        this.downloaders = cfg.downloaders.freeze();
        this.namespace = cfg.namespace;
        this.dereferencing = cfg.dereferencing;
        this.schemaRedirects = ImmutableMap.copyOf(cfg.schemaRedirects);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.preloadedSchemas);
        this.enableCache = cfg.enableCache;
    }

    public Dictionary<URIDownloader> getDownloaders() {
        return this.downloaders;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public Dereferencing getDereferencing() {
        return this.dereferencing;
    }

    public Map<URI, URI> getSchemaRedirects() {
        return this.schemaRedirects;
    }

    public Map<URI, JsonNode> getPreloadedSchemas() {
        return this.preloadedSchemas;
    }

    public boolean getEnableCache() {
        return this.enableCache;
    }

    @Override
    public LoadingConfigurationBuilder thaw() {
        return new LoadingConfigurationBuilder(this);
    }
}

