/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg;

import java.io.IOException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonToken;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg.JSONObjectDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONObject;

public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    @Override
    public JSONArray deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        JSONArray jSONArray = new JSONArray();
        block11: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            switch (jsonToken) {
                case START_ARRAY: {
                    jSONArray.put(this.deserialize(jsonParser, deserializationContext));
                    continue block11;
                }
                case START_OBJECT: {
                    jSONArray.put(JSONObjectDeserializer.instance.deserialize(jsonParser, deserializationContext));
                    continue block11;
                }
                case VALUE_STRING: {
                    jSONArray.put(jsonParser.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    jSONArray.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    jSONArray.put(Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    jSONArray.put(Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    jSONArray.put(jsonParser.getNumberValue());
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    jSONArray.put(jsonParser.getNumberValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    jSONArray.put(jsonParser.getEmbeddedObject());
                    continue block11;
                }
            }
            throw deserializationContext.mappingException("Unrecognized or unsupported JsonToken type: " + (Object)((Object)jsonToken));
        }
        return jSONArray;
    }
}

