/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.io.SerializedString;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JavaType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.util.EnumValues;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    @Deprecated
    public EnumSerializer(EnumValues enumValues) {
        this(enumValues, null);
    }

    public EnumSerializer(EnumValues enumValues, Boolean bl) {
        super(Enum.class, false);
        this._values = enumValues;
        this._serializeAsIndex = bl;
    }

    public static EnumSerializer construct(Class<Enum<?>> clazz, SerializationConfig serializationConfig, BeanDescription beanDescription, JsonFormat.Value value) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        EnumValues enumValues = serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? EnumValues.constructFromToString(clazz, annotationIntrospector) : EnumValues.constructFromName(clazz, annotationIntrospector);
        Boolean bl = EnumSerializer._isShapeWrittenUsingIndex(clazz, value, true);
        return new EnumSerializer(enumValues, bl);
    }

    @Deprecated
    public static EnumSerializer construct(Class<Enum<?>> clazz, SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return EnumSerializer.construct(clazz, serializationConfig, beanDescription, beanDescription.findExpectedFormat(null));
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl;
        JsonFormat.Value value;
        if (beanProperty != null && (value = serializerProvider.getAnnotationIntrospector().findFormat((Annotated)beanProperty.getMember())) != null && (bl = EnumSerializer._isShapeWrittenUsingIndex(beanProperty.getType().getRawClass(), value, false)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, bl);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> enum_, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._serializeAsIndex(serializerProvider)) {
            jsonGenerator.writeNumber(enum_.ordinal());
            return;
        }
        jsonGenerator.writeString(this._values.serializedValueFor(enum_));
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        JavaType javaType;
        if (this._serializeAsIndex(serializerProvider)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (type != null && (javaType = serializerProvider.constructType(type)).isEnumType()) {
            ArrayNode arrayNode = objectNode.putArray("enum");
            for (SerializedString serializedString : this._values.values()) {
                arrayNode.add(serializedString.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper.getProvider().isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX)) {
            JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
            if (jsonIntegerFormatVisitor != null) {
                jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.INT);
            }
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (javaType != null && jsonStringFormatVisitor != null && javaType.isEnumType()) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                for (SerializedString serializedString : this._values.values()) {
                    linkedHashSet.add(serializedString.getValue());
                }
                jsonStringFormatVisitor.enumTypes(linkedHashSet);
            }
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializerProvider) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> clazz, JsonFormat.Value value, boolean bl) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = value == null ? null : value.getShape();
        if (shape == null) {
            return null;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return null;
        }
        if (shape == JsonFormat.Shape.STRING) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric()) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("Unsupported serialization shape (" + (Object)((Object)shape) + ") for Enum " + clazz.getName() + ", not supported as " + (bl ? "class" : "property") + " annotation");
    }
}

