/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonToken;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JavaType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{UUIDDeserializer.instance, URLDeserializer.instance, URIDeserializer.instance, FileDeserializer.instance, CurrencyDeserializer.instance, PatternDeserializer.instance, LocaleDeserializer.instance, InetAddressDeserializer.instance, CharsetDeserializer.instance, AtomicBooleanDeserializer.instance, ClassDeserializer.instance, StackTraceElementDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (!_classNames.contains(string)) {
            return null;
        }
        if (clazz == URI.class) {
            return URIDeserializer.instance;
        }
        if (clazz == URL.class) {
            return URLDeserializer.instance;
        }
        if (clazz == File.class) {
            return FileDeserializer.instance;
        }
        if (clazz == UUID.class) {
            return UUIDDeserializer.instance;
        }
        if (clazz == Currency.class) {
            return CurrencyDeserializer.instance;
        }
        if (clazz == Pattern.class) {
            return PatternDeserializer.instance;
        }
        if (clazz == Locale.class) {
            return LocaleDeserializer.instance;
        }
        if (clazz == InetAddress.class) {
            return InetAddressDeserializer.instance;
        }
        if (clazz == Charset.class) {
            return CharsetDeserializer.instance;
        }
        if (clazz == Class.class) {
            return ClassDeserializer.instance;
        }
        if (clazz == StackTraceElement.class) {
            return StackTraceElementDeserializer.instance;
        }
        if (clazz == AtomicBoolean.class) {
            return AtomicBooleanDeserializer.instance;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + string);
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, URL.class, URI.class, File.class, Currency.class, Pattern.class, Locale.class, InetAddress.class, Charset.class, AtomicBoolean.class, Class.class, StackTraceElement.class}) {
            _classNames.add(clazz.getName());
        }
    }

    public static class StackTraceElementDeserializer
    extends StdScalarDeserializer<StackTraceElement> {
        public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

        public StackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        @Override
        public StackTraceElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.START_OBJECT) {
                String string = "";
                String string2 = "";
                String string3 = "";
                int n = -1;
                while ((jsonToken = jsonParser.nextValue()) != JsonToken.END_OBJECT) {
                    String string4 = jsonParser.getCurrentName();
                    if ("className".equals(string4)) {
                        string = jsonParser.getText();
                        continue;
                    }
                    if ("fileName".equals(string4)) {
                        string3 = jsonParser.getText();
                        continue;
                    }
                    if ("lineNumber".equals(string4)) {
                        if (jsonToken.isNumeric()) {
                            n = jsonParser.getIntValue();
                            continue;
                        }
                        throw JsonMappingException.from(jsonParser, "Non-numeric token (" + (Object)((Object)jsonToken) + ") for property 'lineNumber'");
                    }
                    if ("methodName".equals(string4)) {
                        string2 = jsonParser.getText();
                        continue;
                    }
                    if ("nativeMethod".equals(string4)) continue;
                    this.handleUnknownProperty(jsonParser, deserializationContext, this._valueClass, string4);
                }
                return new StackTraceElement(string, string2, string3, n);
            }
            throw deserializationContext.mappingException(this._valueClass, jsonToken);
        }
    }

    public static class AtomicBooleanDeserializer
    extends StdScalarDeserializer<AtomicBoolean> {
        public static final AtomicBooleanDeserializer instance = new AtomicBooleanDeserializer();

        public AtomicBooleanDeserializer() {
            super(AtomicBoolean.class);
        }

        @Override
        public AtomicBoolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new AtomicBoolean(this._parseBooleanPrimitive(jsonParser, deserializationContext));
        }
    }

    public static class AtomicReferenceDeserializer
    extends StdScalarDeserializer<AtomicReference<?>>
    implements ContextualDeserializer {
        protected final JavaType _referencedType;
        protected final JsonDeserializer<?> _valueDeserializer;

        public AtomicReferenceDeserializer(JavaType javaType) {
            this(javaType, null);
        }

        public AtomicReferenceDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
            super(AtomicReference.class);
            this._referencedType = javaType;
            this._valueDeserializer = jsonDeserializer;
        }

        @Override
        public AtomicReference<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new AtomicReference(this._valueDeserializer.deserialize(jsonParser, deserializationContext));
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonDeserializer<?> jsonDeserializer = this._valueDeserializer;
            if (jsonDeserializer != null) {
                return this;
            }
            return new AtomicReferenceDeserializer(this._referencedType, deserializationContext.findContextualValueDeserializer(this._referencedType, beanProperty));
        }
    }

    public static class FileDeserializer
    extends FromStringDeserializer<File> {
        public static final FileDeserializer instance = new FileDeserializer();

        public FileDeserializer() {
            super(File.class);
        }

        @Override
        protected File _deserialize(String string, DeserializationContext deserializationContext) {
            return new File(string);
        }
    }

    protected static class CharsetDeserializer
    extends FromStringDeserializer<Charset> {
        public static final CharsetDeserializer instance = new CharsetDeserializer();

        public CharsetDeserializer() {
            super(Charset.class);
        }

        @Override
        protected Charset _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return Charset.forName(string);
        }
    }

    protected static class InetAddressDeserializer
    extends FromStringDeserializer<InetAddress> {
        public static final InetAddressDeserializer instance = new InetAddressDeserializer();

        public InetAddressDeserializer() {
            super(InetAddress.class);
        }

        @Override
        protected InetAddress _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return InetAddress.getByName(string);
        }
    }

    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public static final LocaleDeserializer instance = new LocaleDeserializer();

        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            int n = string.indexOf(95);
            if (n < 0) {
                return new Locale(string);
            }
            String string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(95)) < 0) {
                return new Locale(string2, string);
            }
            String string3 = string.substring(0, n);
            return new Locale(string2, string3, string.substring(n + 1));
        }
    }

    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public static final PatternDeserializer instance = new PatternDeserializer();

        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Pattern.compile(string);
        }
    }

    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public static final CurrencyDeserializer instance = new CurrencyDeserializer();

        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Currency.getInstance(string);
        }
    }

    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public static final URIDeserializer instance = new URIDeserializer();

        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return URI.create(string);
        }
    }

    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public static final URLDeserializer instance = new URLDeserializer();

        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return new URL(string);
        }
    }

    public static class UUIDDeserializer
    extends FromStringDeserializer<UUID> {
        public static final UUIDDeserializer instance = new UUIDDeserializer();

        public UUIDDeserializer() {
            super(UUID.class);
        }

        @Override
        protected UUID _deserialize(String string, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return UUID.fromString(string);
        }

        @Override
        protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length != 16) {
                    deserializationContext.mappingException("Can only construct UUIDs from 16 byte arrays; got " + byArray.length + " bytes");
                }
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                long l = dataInputStream.readLong();
                long l2 = dataInputStream.readLong();
                return new UUID(l, l2);
            }
            super._deserializeEmbedded(object, deserializationContext);
            return null;
        }
    }
}

