/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonLocation;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonToken;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JavaType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.CreatorProperty;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.util.TokenBuffer;

public class JacksonDeserializers {
    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{JavaTypeDeserializer.instance, TokenBufferDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> clazz) {
        if (clazz == TokenBuffer.class) {
            return TokenBufferDeserializer.instance;
        }
        if (JavaType.class.isAssignableFrom(clazz)) {
            return JavaTypeDeserializer.instance;
        }
        return null;
    }

    public static ValueInstantiator findValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if (beanDescription.getBeanClass() == JsonLocation.class) {
            return JsonLocationInstantiator.instance;
        }
        return null;
    }

    @JacksonStdImpl
    public static class TokenBufferDeserializer
    extends StdScalarDeserializer<TokenBuffer> {
        public static final TokenBufferDeserializer instance = new TokenBufferDeserializer();

        public TokenBufferDeserializer() {
            super(TokenBuffer.class);
        }

        @Override
        public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
            tokenBuffer.copyCurrentStructure(jsonParser);
            return tokenBuffer;
        }
    }

    public static class JsonLocationInstantiator
    extends ValueInstantiator {
        public static final JsonLocationInstantiator instance = new JsonLocationInstantiator();

        @Override
        public String getValueTypeDesc() {
            return JsonLocation.class.getName();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return true;
        }

        public CreatorProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
            JavaType javaType = deserializationConfig.constructType(Integer.TYPE);
            JavaType javaType2 = deserializationConfig.constructType(Long.TYPE);
            return new CreatorProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", deserializationConfig.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", javaType2, 1), JsonLocationInstantiator.creatorProp("charOffset", javaType2, 2), JsonLocationInstantiator.creatorProp("lineNr", javaType, 3), JsonLocationInstantiator.creatorProp("columnNr", javaType, 4)};
        }

        private static CreatorProperty creatorProp(String string, JavaType javaType, int n) {
            return new CreatorProperty(string, javaType, null, null, null, null, n, null, true);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
            return new JsonLocation(objectArray[0], JsonLocationInstantiator._long(objectArray[1]), JsonLocationInstantiator._long(objectArray[2]), JsonLocationInstantiator._int(objectArray[3]), JsonLocationInstantiator._int(objectArray[4]));
        }

        private static final long _long(Object object) {
            return object == null ? 0L : ((Number)object).longValue();
        }

        private static final int _int(Object object) {
            return object == null ? 0 : ((Number)object).intValue();
        }
    }

    public static class JavaTypeDeserializer
    extends StdScalarDeserializer<JavaType> {
        public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

        public JavaTypeDeserializer() {
            super(JavaType.class);
        }

        @Override
        public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (JavaType)this.getEmptyValue();
                }
                return deserializationContext.getTypeFactory().constructFromCanonical(string);
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (JavaType)jsonParser.getEmbeddedObject();
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
    }
}

