/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.base;

import java.io.IOException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.Base64Variant;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonParser;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonStreamContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonToken;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.Version;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.io.NumberInput;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_APOSTROPHE = 39;
    protected static final int INT_b = 98;
    protected static final int INT_f = 102;
    protected static final int INT_n = 110;
    protected static final int INT_r = 114;
    protected static final int INT_t = 116;
    protected static final int INT_u = 117;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int n) {
        super(n);
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public JsonToken nextValue() throws IOException, JsonParseException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (jsonToken) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++n;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--n != 0) break;
                    return this;
                }
            }
        }
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public abstract String getCurrentName() throws IOException, JsonParseException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText() throws IOException, JsonParseException;

    @Override
    public abstract char[] getTextCharacters() throws IOException, JsonParseException;

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength() throws IOException, JsonParseException;

    @Override
    public abstract int getTextOffset() throws IOException, JsonParseException;

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1) throws IOException, JsonParseException;

    @Override
    public boolean getValueAsBoolean(boolean bl) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: {
                    return this.getIntValue() != 0;
                }
                case VALUE_TRUE: {
                    return true;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return false;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (object instanceof Boolean) {
                        return (Boolean)object;
                    }
                }
                case VALUE_STRING: {
                    Object object = this.getText().trim();
                    if (!"true".equals(object)) break;
                    return true;
                }
            }
        }
        return bl;
    }

    @Override
    public int getValueAsInt(int n) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getIntValue();
                }
                case VALUE_TRUE: {
                    return 1;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsInt(this.getText(), n);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n;
    }

    @Override
    public long getValueAsLong(long l) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getLongValue();
                }
                case VALUE_TRUE: {
                    return 1L;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0L;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsLong(this.getText(), l);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l;
    }

    @Override
    public double getValueAsDouble(double d) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getDoubleValue();
                }
                case VALUE_TRUE: {
                    return 1.0;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0.0;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsDouble(this.getText(), d);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d;
    }

    @Override
    public String getValueAsString(String string) throws IOException, JsonParseException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException, JsonParseException {
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c;
            do {
                c = string.charAt(n++);
                if (n >= n2) break block0;
            } while (c <= ' ');
            int n3 = base64Variant.decodeBase64Char(c);
            if (n3 < 0) {
                this._reportInvalidBase64(base64Variant, c, 0, null);
            }
            int n4 = n3;
            if (n >= n2) {
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                this._reportInvalidBase64(base64Variant, c, 1, null);
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.append(n4 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 2, null);
                }
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if (!base64Variant.usesPaddingChar(c = string.charAt(n++))) {
                    this._reportInvalidBase64(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n4 >>= 4);
                continue;
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 3, null);
                }
                byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                continue;
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n, String string) throws JsonParseException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructError(string2);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw this._constructError("Unexpected end-of-String in base64 content");
    }

    protected void _reportUnexpectedChar(int n, String string) throws JsonParseException {
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) throws JsonParseException {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _reportInvalidEOFInValue() throws JsonParseException {
        this._reportInvalidEOF(" in a value");
    }

    protected void _throwInvalidSpace(int n) throws JsonParseException {
        char c = (char)n;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n, String string) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n >= 32) {
            char c = (char)n;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c;
        }
        if (c == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c));
        return c;
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) throws JsonParseException {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }
}

