/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.Chronology;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.DateTime;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.DateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.DateTimeFieldType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.DateTimeZone;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.chrono.AssembledChronology;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.chrono.GJChronology;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.chrono.LimitChronology;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.field.DelegatedDateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.field.DividedDateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.field.OffsetDateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.field.RemainderDateTimeField;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.joda.time.field.SkipUndoDateTimeField;

public final class BuddhistChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3474595157769370126L;
    public static final int BE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("BE");
    private static final int BUDDHIST_OFFSET = 543;
    private static final Map<DateTimeZone, BuddhistChronology> cCache = new HashMap<DateTimeZone, BuddhistChronology>();
    private static final BuddhistChronology INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    public static synchronized BuddhistChronology getInstance(DateTimeZone dateTimeZone) {
        BuddhistChronology buddhistChronology;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((buddhistChronology = cCache.get(dateTimeZone)) == null) {
            buddhistChronology = new BuddhistChronology(GJChronology.getInstance(dateTimeZone, null), null);
            DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, buddhistChronology);
            buddhistChronology = new BuddhistChronology(LimitChronology.getInstance(buddhistChronology, dateTime, null), "");
            cCache.put(dateTimeZone, buddhistChronology);
        }
        return buddhistChronology;
    }

    private BuddhistChronology(Chronology chronology, Object object) {
        super(chronology, object);
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        return chronology == null ? BuddhistChronology.getInstanceUTC() : BuddhistChronology.getInstance(chronology.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(dateTimeZone);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return "Buddhist".hashCode() * 11 + this.getZone().hashCode();
    }

    public String toString() {
        String string = "BuddhistChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string = string + '[' + dateTimeZone.getID() + ']';
        }
        return string;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getParam() == null) {
            DateTimeField dateTimeField = fields.year;
            fields.year = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = fields.yearOfEra;
            fields.yearOfEra = new DelegatedDateTimeField(fields.year, DateTimeFieldType.yearOfEra());
            dateTimeField = fields.weekyear;
            fields.weekyear = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = new OffsetDateTimeField(fields.yearOfEra, 99);
            fields.centuryOfEra = new DividedDateTimeField(dateTimeField, DateTimeFieldType.centuryOfEra(), 100);
            dateTimeField = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra);
            fields.yearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.yearOfCentury(), 1);
            dateTimeField = new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100);
            fields.weekyearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.weekyearOfCentury(), 1);
            fields.era = ERA_FIELD;
        }
    }
}

