/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.i18n.phonenumbers;

import java.util.regex.Pattern;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.i18n.phonenumbers.PhoneNumberUtil;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.i18n.phonenumbers.Phonemetadata;

public class ShortNumberUtil {
    private final PhoneNumberUtil phoneUtil;

    public ShortNumberUtil() {
        this.phoneUtil = PhoneNumberUtil.getInstance();
    }

    ShortNumberUtil(PhoneNumberUtil util) {
        this.phoneUtil = util;
    }

    public boolean connectsToEmergencyNumber(String number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, true);
    }

    public boolean isEmergencyNumber(String number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, false);
    }

    private boolean matchesEmergencyNumberHelper(String number, String regionCode, boolean allowPrefixMatch) {
        if (PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(number = PhoneNumberUtil.extractPossibleNumber(number)).lookingAt()) {
            return false;
        }
        Phonemetadata.PhoneMetadata metadata = this.phoneUtil.getMetadataForRegion(regionCode);
        if (metadata == null || !metadata.hasEmergency()) {
            return false;
        }
        Pattern emergencyNumberPattern = Pattern.compile(metadata.getEmergency().getNationalNumberPattern());
        String normalizedNumber = PhoneNumberUtil.normalizeDigitsOnly(number);
        return !allowPrefixMatch || regionCode.equals("BR") ? emergencyNumberPattern.matcher(normalizedNumber).matches() : emergencyNumberPattern.matcher(normalizedNumber).lookingAt();
    }
}

