/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Preconditions;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash.AbstractCompositeHashFunction;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash.HashCode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash.HashCodes;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash.HashFunction;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.hash.Hasher;

final class BloomFilterStrategies {
    private BloomFilterStrategies() {
    }

    private static int checkPositiveAndMakeMultipleOf64(int bits) {
        Preconditions.checkArgument(bits > 0, "Number of bits must be positive");
        return bits + 63 & 0xFFFFFFC0;
    }

    private static HashCode compose64(long hash1, long hash2, int bits) {
        byte[] bytes = new byte[bits / 8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        long numLongs = bits / 64;
        for (long i = 1L; i <= numLongs; ++i) {
            buf.putLong(hash1 + i * hash2);
        }
        return HashCodes.fromBytes(bytes);
    }

    static class From128ToN
    extends AbstractCompositeHashFunction
    implements Serializable {
        private final int bits;
        private final HashFunction hashFunction;

        private From128ToN(int longs, HashFunction hashFunction) {
            super(hashFunction);
            this.hashFunction = hashFunction;
            this.bits = longs;
        }

        static From128ToN withBits(int bits, HashFunction hashFunction) {
            return new From128ToN(BloomFilterStrategies.checkPositiveAndMakeMultipleOf64(bits), hashFunction);
        }

        HashCode makeHash(Hasher[] hashers) {
            ByteBuffer buf = ByteBuffer.wrap(hashers[0].hash().asBytes());
            long hash1 = buf.getLong();
            long hash2 = buf.getLong();
            return BloomFilterStrategies.compose64(hash1, hash2, this.bits);
        }

        public int bits() {
            return this.bits;
        }

        private Object writeReplace() {
            return new SerialForm(this);
        }

        private static class SerialForm
        implements Serializable {
            final int bits;
            final HashFunction hashFunction;
            private static final long serialVersionUID = 0L;

            SerialForm(From128ToN object) {
                this.bits = object.bits;
                this.hashFunction = object.hashFunction;
            }

            Object readResolve() {
                return From128ToN.withBits(this.bits, this.hashFunction);
            }
        }
    }
}

