/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util;

import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.MessageProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.AsJson;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.AsJsonValueHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.SimpleValueHolder;

@Immutable
public abstract class ValueHolder<T>
implements MessageProvider {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final String name;
    protected final T value;

    public static <V> ValueHolder<V> hold(V value) {
        return new SimpleValueHolder<V>("value", value);
    }

    public static <V> ValueHolder<V> hold(String name, V value) {
        return new SimpleValueHolder<V>(name, value);
    }

    public static <V extends AsJson> ValueHolder<V> hold(V value) {
        return new AsJsonValueHolder<V>("value", value);
    }

    public static <V extends AsJson> ValueHolder<V> hold(String name, V value) {
        return new AsJsonValueHolder<V>(name, value);
    }

    protected ValueHolder(String name, T value) {
        this.name = name;
        this.value = value;
    }

    protected abstract JsonNode valueAsJson();

    public final T getValue() {
        return this.value;
    }

    @Override
    public final ProcessingMessage newMessage() {
        return new ProcessingMessage().put(this.name, this.valueAsJson());
    }
}

