/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report;

import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.AbstractProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.AsJson;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Iterators;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;

public final class ListProcessingReport
extends AbstractProcessingReport
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final List<ProcessingMessage> messages = Lists.newArrayList();

    public ListProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        super(logLevel, exceptionThreshold);
    }

    public ListProcessingReport(LogLevel logLevel) {
        super(logLevel);
    }

    public ListProcessingReport() {
    }

    public ListProcessingReport(ProcessingReport other) {
        this(other.getLogLevel(), other.getExceptionThreshold());
    }

    @Override
    public void log(LogLevel level, ProcessingMessage message) {
        this.messages.add(message);
    }

    @Override
    public JsonNode asJson() {
        ArrayNode ret = FACTORY.arrayNode();
        for (ProcessingMessage message : this.messages) {
            ret.add(message.asJson());
        }
        return ret;
    }

    @Override
    public Iterator<ProcessingMessage> iterator() {
        return Iterators.unmodifiableIterator(this.messages.iterator());
    }
}

