/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.Digester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class ArraySchemaDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new ArraySchemaDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private ArraySchemaDigester() {
        super("", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("itemsSize", 0);
        ret.put("itemsIsArray", false);
        JsonNode itemsNode = schema.path("items");
        JsonNode additionalNode = schema.path("additionalItems");
        boolean hasItems = !itemsNode.isMissingNode();
        boolean hasAdditional = additionalNode.isObject();
        ret.put("hasItems", hasItems);
        ret.put("hasAdditional", hasAdditional);
        if (itemsNode.isArray()) {
            ret.put("itemsIsArray", true);
            ret.put("itemsSize", itemsNode.size());
        }
        return ret;
    }
}

