/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax;

import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessingResult;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessorMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.DevNullProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.CanonicalSchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Function;

public final class SyntaxValidator {
    private final Processor<SchemaHolder, SchemaHolder> processor;

    public SyntaxValidator(ValidationConfiguration cfg) {
        ProcessorMap map = new SchemaMap();
        SyntaxProcessor byDefault = new SyntaxProcessor(cfg.getDefaultLibrary().getSyntaxCheckers());
        map = map.setDefaultProcessor(byDefault);
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            Dictionary<SyntaxChecker> dict = entry.getValue().getSyntaxCheckers();
            SyntaxProcessor syntaxProcessor = new SyntaxProcessor(dict);
            map = map.addEntry(ref, syntaxProcessor);
        }
        this.processor = map.getProcessor();
    }

    public boolean schemaIsValid(JsonNode schema) {
        DevNullProcessingReport report = new DevNullProcessingReport();
        return this.getResult(schema, report).isSuccess();
    }

    public ProcessingReport validateSchema(JsonNode schema) {
        ListProcessingReport report = new ListProcessingReport();
        return this.getResult(schema, report).getReport();
    }

    public Processor<SchemaHolder, SchemaHolder> getProcessor() {
        return this.processor;
    }

    private ProcessingResult<SchemaHolder> getResult(JsonNode schema, ProcessingReport report) {
        SchemaHolder holder = SyntaxValidator.holder(schema);
        return ProcessingResult.uncheckedResult(this.processor, report, holder);
    }

    private static SchemaHolder holder(JsonNode node) {
        return new SchemaHolder(new CanonicalSchemaTree(node));
    }

    private static final class SchemaMap
    extends ProcessorMap<JsonRef, SchemaHolder, SchemaHolder> {
        private SchemaMap() {
        }

        @Override
        protected Function<SchemaHolder, JsonRef> f() {
            return new Function<SchemaHolder, JsonRef>(){

                @Override
                public JsonRef apply(SchemaHolder input) {
                    return ((SchemaTree)input.getValue()).getDollarSchema();
                }
            };
        }
    }
}

