/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessorBuildError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ProcessingErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessorSelectorPredicate;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.MessageProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Predicate;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

@Immutable
public final class ProcessorSelector<IN extends MessageProvider, OUT extends MessageProvider> {
    final Map<Predicate<IN>, Processor<IN, OUT>> choices;
    final Processor<IN, OUT> byDefault;

    public ProcessorSelector() {
        this.choices = Maps.newLinkedHashMap();
        this.byDefault = null;
    }

    private ProcessorSelector(Map<Predicate<IN>, Processor<IN, OUT>> choices, Processor<IN, OUT> byDefault) {
        this.choices = Maps.newLinkedHashMap(choices);
        this.byDefault = byDefault;
    }

    ProcessorSelector(ProcessorSelectorPredicate<IN, OUT> selector) {
        this(selector.choices, selector.byDefault);
    }

    public ProcessorSelectorPredicate<IN, OUT> when(Predicate<IN> predicate) {
        if (predicate == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PREDICATE));
        }
        return new ProcessorSelectorPredicate(this, predicate);
    }

    public ProcessorSelector<IN, OUT> otherwise(Processor<IN, OUT> byDefault) {
        if (byDefault == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        return new ProcessorSelector<IN, OUT>(this.choices, byDefault);
    }

    public Processor<IN, OUT> getProcessor() {
        return new Chooser(this.choices, this.byDefault);
    }

    private static final class Chooser<X extends MessageProvider, Y extends MessageProvider>
    implements Processor<X, Y> {
        private final Map<Predicate<X>, Processor<X, Y>> map;
        private final Processor<X, Y> byDefault;

        private Chooser(Map<Predicate<X>, Processor<X, Y>> map, Processor<X, Y> byDefault) {
            this.map = ImmutableMap.copyOf(map);
            this.byDefault = byDefault;
        }

        @Override
        public Y process(ProcessingReport report, X input) throws ProcessingException {
            for (Map.Entry<Predicate<X>, Processor<X, Y>> entry : this.map.entrySet()) {
                Predicate<X> predicate = entry.getKey();
                Processor<X, Y> processor = entry.getValue();
                if (!predicate.apply(input)) continue;
                return processor.process(report, input);
            }
            if (this.byDefault != null) {
                return this.byDefault.process(report, input);
            }
            throw new ProcessingException(input.newMessage().message(ProcessingErrors.NO_SUITABLE_PROCESSOR));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("selector[").append(this.map.size()).append(" choices with ");
            if (this.byDefault == null) {
                sb.append("no ");
            }
            return sb.append("default]").toString();
        }
    }
}

