/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing;

import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessorBuildError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ProcessingErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.MessageProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Function;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

@NotThreadSafe
public abstract class ProcessorMap<K, IN extends MessageProvider, OUT extends MessageProvider> {
    private final Map<K, Processor<IN, OUT>> processors = Maps.newHashMap();
    private Processor<IN, OUT> defaultProcessor = null;

    public final ProcessorMap<K, IN, OUT> addEntry(K key, Processor<IN, OUT> processor) {
        if (key == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_KEY));
        }
        if (processor == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        this.processors.put(key, processor);
        return this;
    }

    public final ProcessorMap<K, IN, OUT> setDefaultProcessor(Processor<IN, OUT> defaultProcessor) {
        if (defaultProcessor == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        this.defaultProcessor = defaultProcessor;
        return this;
    }

    public final Processor<IN, OUT> getProcessor() {
        return new Mapper(this.processors, this.f(), this.defaultProcessor);
    }

    protected abstract Function<IN, K> f();

    private static final class Mapper<K, IN extends MessageProvider, OUT extends MessageProvider>
    implements Processor<IN, OUT> {
        private final Map<K, Processor<IN, OUT>> processors;
        private final Function<IN, K> f;
        private final Processor<IN, OUT> defaultProcessor;

        private Mapper(Map<K, Processor<IN, OUT>> processors, Function<IN, K> f, Processor<IN, OUT> defaultProcessor) {
            if (f == null) {
                throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_FUNCTION));
            }
            this.processors = ImmutableMap.copyOf(processors);
            this.f = f;
            this.defaultProcessor = defaultProcessor;
        }

        @Override
        public OUT process(ProcessingReport report, IN input) throws ProcessingException {
            K key = this.f.apply(input);
            Processor<IN, OUT> processor = this.processors.get(key);
            if (processor == null) {
                processor = this.defaultProcessor;
            }
            if (processor == null) {
                throw new ProcessingException(new ProcessingMessage().message(ProcessingErrors.NO_SUITABLE_PROCESSOR).put("key", key));
            }
            return processor.process(report, input);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("map[").append(this.processors.size()).append(" entries with ");
            if (this.defaultProcessor == null) {
                sb.append("no ");
            }
            return sb.append("default]").toString();
        }
    }
}

