/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main;

import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.JsonReferenceException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.SchemaLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.LoadingConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.RefProcessingMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessingResult;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ReportProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SimpleJsonTree;

@Immutable
public final class JsonValidator {
    private final SchemaLoader loader;
    private final ValidationProcessor processor;
    private final ReportProvider reportProvider;

    JsonValidator(SchemaLoader loader, ValidationProcessor processor, ReportProvider reportProvider) {
        this.loader = loader;
        this.processor = processor;
        this.reportProvider = reportProvider;
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance);
        return ProcessingResult.of(this.processor, report, data).getReport();
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance);
        return ProcessingResult.uncheckedResult(this.processor, report, data).getReport();
    }

    JsonSchema buildJsonSchema(JsonNode schema, JsonPointer pointer) throws ProcessingException {
        SchemaTree tree = this.loader.load(schema).setPointer(pointer);
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().message(RefProcessingMessages.DANGLING_REF));
        }
        return new JsonSchema(this.processor, tree, this.reportProvider);
    }

    JsonSchema buildJsonSchema(String uri) throws ProcessingException {
        JsonRef ref = JsonRef.fromString(uri);
        if (!ref.isLegal()) {
            throw new JsonReferenceException(new ProcessingMessage().message(RefProcessingMessages.ILLEGAL_JSON_REF));
        }
        SchemaTree tree = this.loader.get(ref.getLocator()).setPointer(ref.getPointer());
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().message(RefProcessingMessages.DANGLING_REF));
        }
        return new JsonSchema(this.processor, tree, this.reportProvider);
    }

    Processor<FullData, FullData> getProcessor() {
        return this.processor;
    }

    private FullData buildData(JsonNode schema, JsonNode instance) {
        if (schema == null) {
            throw new ProcessingError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        if (instance == null) {
            throw new ProcessingError(new ProcessingMessage().message(ConfigurationMessages.NULL_INSTANCE));
        }
        SchemaTree schemaTree = this.loader.load(schema);
        SimpleJsonTree tree = new SimpleJsonTree(instance);
        return new FullData(schemaTree, tree);
    }
}

