/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.URIDownloader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.RefProcessingMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Preconditions;

public final class URIManager {
    private static final ObjectReader READER = JacksonUtils.getReader();
    private final Map<String, URIDownloader> downloaders;
    private final Map<URI, URI> schemaRedirects;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaders().entries();
        this.schemaRedirects = cfg.getSchemaRedirects();
    }

    public JsonNode getContent(URI uri) throws ProcessingException {
        Preconditions.checkNotNull(uri, "null URI");
        URI target = this.schemaRedirects.containsKey(uri) ? this.schemaRedirects.get(uri) : uri;
        ProcessingMessage msg = new ProcessingMessage().put("uri", uri);
        if (!target.isAbsolute()) {
            throw new ProcessingException(msg.message(RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        String scheme = target.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(msg.message(RefProcessingMessages.UNHANDLED_SCHEME).put("scheme", scheme));
        }
        try {
            InputStream in = downloader.fetch(target);
            return READER.readTree(in);
        }
        catch (JsonProcessingException e) {
            throw new ProcessingException(msg.message(RefProcessingMessages.URI_NOT_JSON).put("parsingMessage", e.getOriginalMessage()));
        }
        catch (IOException e) {
            throw new ProcessingException(msg.message(RefProcessingMessages.URI_IOERROR).put("exceptionMessage", e.getMessage()));
        }
    }
}

