/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.ThreadSafe;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.Dereferencing;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.URIManager;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.LoadingConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.RefProcessingMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheBuilderSpec;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.LoadingCache;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableMap;

@ThreadSafe
public final class SchemaLoader {
    private final URIManager manager;
    private final JsonRef namespace;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;
    private final Map<URI, JsonNode> preloadedSchemas;

    public SchemaLoader(LoadingConfiguration cfg) {
        this.namespace = JsonRef.fromURI(cfg.getNamespace());
        this.dereferencing = cfg.getDereferencing();
        this.manager = new URIManager(cfg);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.getPreloadedSchemas());
        CacheBuilder cacheBuilder = cfg.getEnableCache() ? CacheBuilder.newBuilder() : CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.disableCaching());
        this.cache = cacheBuilder.build(new CacheLoader<URI, JsonNode>(){

            @Override
            public JsonNode load(URI key) throws ProcessingException {
                return SchemaLoader.this.manager.getContent(key);
            }
        });
    }

    public SchemaLoader() {
        this(LoadingConfiguration.byDefault());
    }

    public SchemaTree load(JsonNode schema) {
        if (schema == null) {
            throw new ProcessingError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        return this.dereferencing.newTree(schema);
    }

    public SchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI(uri));
        ProcessingMessage msg = new ProcessingMessage().put("uri", ref);
        if (!ref.isAbsolute()) {
            throw new ProcessingException(msg.message(RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = this.preloadedSchemas.get(realURI);
            if (node == null) {
                node = this.cache.get(realURI);
            }
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

