/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library;

import java.lang.reflect.Constructor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.Digester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.DictionaryBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Keyword;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ValidationConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.Thawed;

public final class LibraryBuilder
implements Thawed<Library> {
    final DictionaryBuilder<SyntaxChecker> syntaxCheckers;
    final DictionaryBuilder<Digester> digesters;
    final DictionaryBuilder<Constructor<? extends KeywordValidator>> validators;
    final DictionaryBuilder<FormatAttribute> formatAttributes;

    LibraryBuilder() {
        this.syntaxCheckers = Dictionary.newBuilder();
        this.digesters = Dictionary.newBuilder();
        this.validators = Dictionary.newBuilder();
        this.formatAttributes = Dictionary.newBuilder();
    }

    LibraryBuilder(Library library) {
        this.syntaxCheckers = library.syntaxCheckers.thaw();
        this.digesters = library.digesters.thaw();
        this.validators = library.validators.thaw();
        this.formatAttributes = library.formatAttributes.thaw();
    }

    public LibraryBuilder addKeyword(Keyword keyword) {
        if (keyword == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ValidationConfigurationMessages.NULL_KEYWORD));
        }
        String name = keyword.name;
        this.removeKeyword(name);
        this.syntaxCheckers.addEntry(name, keyword.syntaxChecker);
        if (keyword.constructor != null) {
            this.digesters.addEntry(name, keyword.digester);
            this.validators.addEntry(name, keyword.constructor);
        }
        return this;
    }

    public LibraryBuilder removeKeyword(String name) {
        if (name == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ValidationConfigurationMessages.NULL_NAME));
        }
        this.syntaxCheckers.removeEntry(name);
        this.digesters.removeEntry(name);
        this.validators.removeEntry(name);
        return this;
    }

    public LibraryBuilder addFormatAttribute(String name, FormatAttribute attribute) {
        this.removeFormatAttribute(name);
        if (attribute == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ValidationConfigurationMessages.NULL_ATTRIBUTE));
        }
        this.formatAttributes.addEntry(name, attribute);
        return this;
    }

    public LibraryBuilder removeFormatAttribute(String name) {
        if (name == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ValidationConfigurationMessages.NULL_FORMAT));
        }
        this.formatAttributes.removeEntry(name);
        return this;
    }

    @Override
    public Library freeze() {
        return new Library(this);
    }
}

