/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public abstract class NumericValidator
extends AbstractKeywordValidator {
    protected final JsonNode number;
    private final boolean isLong;

    protected NumericValidator(String keyword, JsonNode digest) {
        super(keyword);
        this.number = digest.get(keyword);
        this.isLong = digest.get("valueIsLong").booleanValue();
    }

    @Override
    public final void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        if (NumericValidator.valueIsLong(instance) && this.isLong) {
            this.validateLong(report, data);
        } else {
            this.validateDecimal(report, data);
        }
    }

    protected abstract void validateLong(ProcessingReport var1, FullData var2) throws ProcessingException;

    protected abstract void validateDecimal(ProcessingReport var1, FullData var2) throws ProcessingException;

    @Override
    public final String toString() {
        return this.keyword + ": " + this.number;
    }

    private static boolean valueIsLong(JsonNode node) {
        return NodeType.getNodeType(node) == NodeType.INTEGER && node.canConvertToLong();
    }
}

