/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.common;

import java.util.HashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class UniqueItemsValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private final boolean uniqueItems;

    public UniqueItemsValidator(JsonNode digest) {
        super("uniqueItems");
        this.uniqueItems = digest.get(this.keyword).booleanValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        if (!this.uniqueItems) {
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        JsonNode node = data.getInstance().getNode();
        for (JsonNode element : node) {
            if (set.add(EQUIVALENCE.wrap(element))) continue;
            report.error(this.newMsg(data).message(KeywordValidationMessages.ELEMENTS_NOT_UNIQUE));
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

