/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.common;

import java.math.BigDecimal;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;

public final class MaximumValidator
extends NumericValidator {
    private final boolean exclusive;

    public MaximumValidator(JsonNode digest) {
        super("maximum", digest);
        this.exclusive = digest.path("exclusive").booleanValue();
    }

    @Override
    protected void validateLong(ProcessingReport report, FullData data) throws ProcessingException {
        long longValue;
        JsonNode instance = data.getInstance().getNode();
        long instanceValue = instance.longValue();
        if (instanceValue < (longValue = this.number.longValue())) {
            return;
        }
        if (instanceValue > longValue) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.NUMBER_TOO_LARGE).put(this.keyword, this.number).put("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data).message(KeywordValidationMessages.NUMBER_EX_LARGE).put(this.keyword, this.number).put("exclusiveMaximum", BooleanNode.TRUE));
    }

    @Override
    protected void validateDecimal(ProcessingReport report, FullData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode instance = data.getInstance().getNode();
        BigDecimal instanceValue = instance.decimalValue();
        int cmp = instanceValue.compareTo(decimalValue = this.number.decimalValue());
        if (cmp < 0) {
            return;
        }
        if (cmp > 0) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.NUMBER_TOO_LARGE).put(this.keyword, this.number).put("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data).message(KeywordValidationMessages.NUMBER_EX_LARGE).put(this.keyword, this.number).put("exclusiveMaximum", BooleanNode.TRUE));
    }
}

