/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class URISyntaxChecker
extends AbstractSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String s = this.getNode(tree).textValue();
        try {
            URI uri = new URI(s);
            if (!uri.equals(uri.normalize())) {
                report.error(this.newMsg(tree, SyntaxMessages.URI_NOT_NORMALIZED).put("value", s));
            }
        }
        catch (URISyntaxException ignored) {
            report.error(this.newMsg(tree, SyntaxMessages.INVALID_URI).put("value", s));
        }
    }
}

