/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.helpers;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

public abstract class DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    protected final EnumSet<NodeType> dependencyTypes;

    protected DependenciesSyntaxChecker(NodeType ... depTypes) {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
        this.dependencyTypes = EnumSet.of(NodeType.OBJECT, depTypes);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        TreeMap<String, JsonNode> map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap(node));
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                pointers.add(JsonPointer.of(this.keyword, key));
                continue;
            }
            this.checkDependency(report, (String)entry.getKey(), tree);
        }
    }

    protected abstract void checkDependency(ProcessingReport var1, String var2, SchemaTree var3) throws ProcessingException;
}

