/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.draftv4;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class DraftV4TypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final EnumSet<NodeType> ALL_TYPES = EnumSet.allOf(NodeType.class);
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new DraftV4TypeSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeSyntaxChecker() {
        super("type", NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        if (node.isTextual()) {
            String s = node.textValue();
            if (NodeType.fromName(s) == null) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("valid", ALL_TYPES).put("found", s));
            }
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap(element));
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("index", index).put("expected", NodeType.STRING).put("found", type));
                continue;
            }
            if (NodeType.fromName(element.textValue()) != null) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("index", index).put("valid", ALL_TYPES).put("found", element));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
        }
    }
}

