/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.draftv3;

import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.helpers.SchemaMapSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

public final class DraftV3PropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3PropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3PropertiesSyntaxChecker() {
        super("properties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        TreeMap<String, JsonNode> map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap(tree.getNode().get(this.keyword)));
        for (Map.Entry entry : map.entrySet()) {
            NodeType type;
            String member = (String)entry.getKey();
            JsonNode required = ((JsonNode)entry.getValue()).get("required");
            if (required == null || (type = NodeType.getNodeType(required)) == NodeType.BOOLEAN) continue;
            report.error(this.newMsg(tree, SyntaxMessages.DRAFTV3_PROPERTIES_REQUIRED).put("property", member).put("expected", NodeType.BOOLEAN).put("found", type));
        }
    }
}

