/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax;

import java.util.Collection;
import java.util.EnumSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ExceptionProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    private static final ExceptionProvider EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    };
    protected final String keyword;
    private final EnumSet<NodeType> types;

    protected AbstractSyntaxChecker(String keyword, NodeType first, NodeType ... other) {
        this.keyword = keyword;
        this.types = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> getValidTypes() {
        return EnumSet.copyOf(this.types);
    }

    @Override
    public final void checkSyntax(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        NodeType type = NodeType.getNodeType(node);
        if (!this.types.contains((Object)type)) {
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_TYPE).put("expected", this.types).put("found", type));
            return;
        }
        this.checkValue(pointers, report, tree);
    }

    protected abstract void checkValue(Collection<JsonPointer> var1, ProcessingReport var2, SchemaTree var3) throws ProcessingException;

    protected final <T> ProcessingMessage newMsg(SchemaTree tree, T msg) {
        return new ProcessingMessage().put("domain", "syntax").put("schema", tree).put("keyword", this.keyword).message(msg).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected final JsonNode getNode(SchemaTree tree) {
        return tree.getNode().get(this.keyword);
    }
}

