/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.draftv4;

import java.util.EnumSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.Digester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class DraftV4TypeDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV4TypeDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeDigester() {
        super("type", NodeType.ARRAY, NodeType.values());
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode allowedTypes = FACTORY.arrayNode();
        ret.put(this.keyword, allowedTypes);
        JsonNode node = schema.get(this.keyword);
        EnumSet<NodeType> typeSet = EnumSet.noneOf(NodeType.class);
        if (node.isTextual()) {
            typeSet.add(NodeType.fromName(node.textValue()));
        } else {
            for (JsonNode element : node) {
                typeSet.add(NodeType.fromName(element.textValue()));
            }
        }
        if (typeSet.contains((Object)NodeType.NUMBER)) {
            typeSet.add(NodeType.INTEGER);
        }
        for (NodeType type : typeSet) {
            allowedTypes.add(type.toString());
        }
        return ret;
    }
}

