/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer;

import java.util.List;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.JsonReferenceException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.JsonReferenceErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.JsonReferenceMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableList;

@Immutable
public final class ReferenceToken {
    private static final char ESCAPE = '~';
    private static final List<Character> ENCODED = ImmutableList.of(Character.valueOf('0'), Character.valueOf('1'));
    private static final List<Character> DECODED = ImmutableList.of(Character.valueOf('~'), Character.valueOf('/'));
    private final String cooked;
    private final String raw;

    private ReferenceToken(String cooked, String raw) {
        this.cooked = cooked;
        this.raw = raw;
    }

    public static ReferenceToken fromCooked(String cooked) throws JsonReferenceException {
        if (cooked == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_INPUT));
        }
        return new ReferenceToken(cooked, ReferenceToken.asRaw(cooked));
    }

    public static ReferenceToken fromRaw(String raw) {
        if (raw == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_INPUT));
        }
        return new ReferenceToken(ReferenceToken.asCooked(raw), raw);
    }

    public static ReferenceToken fromInt(int index) {
        String s = Integer.toString(index);
        return new ReferenceToken(s, s);
    }

    public String getRaw() {
        return this.raw;
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceToken other = (ReferenceToken)obj;
        return this.raw.equals(other.raw);
    }

    public String toString() {
        return this.cooked;
    }

    private static String asRaw(String cooked) throws JsonReferenceException {
        StringBuilder raw = new StringBuilder(cooked.length());
        String s = cooked;
        boolean inEscape = false;
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            s = s.substring(1);
            if (inEscape) {
                ReferenceToken.appendEscaped(raw, c);
                inEscape = false;
                continue;
            }
            if (c == '~') {
                inEscape = true;
                continue;
            }
            raw.append(c);
        }
        if (inEscape) {
            throw new JsonReferenceException(new ProcessingMessage().message(JsonReferenceMessages.EMPTY_ESCAPE));
        }
        return raw.toString();
    }

    private static void appendEscaped(StringBuilder sb, char c) throws JsonReferenceException {
        int index = ENCODED.indexOf(Character.valueOf(c));
        if (index == -1) {
            throw new JsonReferenceException(new ProcessingMessage().message(JsonReferenceMessages.ILLEGAL_ESCAPE).put("valid", ENCODED).put("found", Character.valueOf(c)));
        }
        sb.append(DECODED.get(index));
    }

    private static String asCooked(String raw) {
        StringBuilder cooked = new StringBuilder(raw.length());
        String s = raw;
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            s = s.substring(1);
            int index = DECODED.indexOf(Character.valueOf(c));
            if (index != -1) {
                cooked.append('~').append(ENCODED.get(index));
                continue;
            }
            cooked.append(c);
        }
        return cooked.toString();
    }
}

