/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.draftv3;

import java.math.BigInteger;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.FormatMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class UTCMillisecAttribute
extends AbstractFormatAttribute {
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");
    private static final FormatAttribute INSTANCE = new UTCMillisecAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private UTCMillisecAttribute() {
        super("utc-millisec", NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    public void validate(ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        BigInteger epoch = instance.bigIntegerValue();
        if (epoch.signum() == -1) {
            report.warn(this.newMsg(data, FormatMessages.EPOCH_NEGATIVE));
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            report.warn(this.newMsg(data, FormatMessages.EPOCH_OVERFLOW));
        }
    }
}

