/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.draftv3;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.FormatMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.i18n.phonenumbers.NumberParseException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.i18n.phonenumbers.PhoneNumberUtil;

public final class PhoneAttribute
extends AbstractFormatAttribute {
    private static final PhoneNumberUtil PARSER = PhoneNumberUtil.getInstance();
    private static final FormatAttribute INSTANCE = new PhoneAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private PhoneAttribute() {
        super("phone", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        try {
            if (input.startsWith("+")) {
                PARSER.parse(input, "ZZ");
            } else {
                PARSER.parse(input, "FR");
            }
        }
        catch (NumberParseException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_PHONE_NUMBER));
        }
    }
}

