/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples.ExampleBase;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.Digester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.DraftV4Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Keyword;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class Example9
extends ExampleBase {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Example9.loadResource("/custom-keyword.json");
        JsonNode good = Example9.loadResource("/custom-keyword-good.json");
        JsonNode bad = Example9.loadResource("/custom-keyword-bad.json");
        Keyword keyword = Keyword.newBuilder("divisors").withSyntaxChecker(DivisorsSyntaxChecker.getInstance()).withDigester(DivisorsDigesters.getInstance()).withValidatorClass(DivisorsKeywordValidator.class).freeze();
        Library library = DraftV4Library.get().thaw().addKeyword(keyword).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        Example9.printReport(report);
        report = schema.validate(bad);
        Example9.printReport(report);
    }

    public static final class DivisorsKeywordValidator
    extends AbstractKeywordValidator {
        private final List<BigInteger> divisors;

        public DivisorsKeywordValidator(JsonNode digest) {
            super("divisors");
            ImmutableList.Builder list = ImmutableList.builder();
            for (JsonNode element : digest) {
                list.add(element.bigIntegerValue());
            }
            this.divisors = list.build();
        }

        @Override
        public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
            BigInteger value = data.getInstance().getNode().bigIntegerValue();
            ArrayList<BigInteger> failed = Lists.newArrayList();
            for (BigInteger divisor : this.divisors) {
                if (value.mod(divisor).equals(BigInteger.ZERO)) continue;
                failed.add(divisor);
            }
            if (failed.isEmpty()) {
                return;
            }
            report.error(this.newMsg(data).message("integer value is not a multiple of all divisors").put("divisors", this.divisors).put("failed", failed));
        }

        @Override
        public String toString() {
            return "divisors: " + this.divisors;
        }
    }

    private static final class DivisorsDigesters
    extends AbstractDigester {
        private static final Digester INSTANCE = new DivisorsDigesters();
        private static final Comparator<JsonNode> COMPARATOR = new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.bigIntegerValue().compareTo(o2.bigIntegerValue());
            }
        };

        public static Digester getInstance() {
            return INSTANCE;
        }

        private DivisorsDigesters() {
            super("divisors", NodeType.INTEGER, new NodeType[0]);
        }

        @Override
        public JsonNode digest(JsonNode schema) {
            TreeSet<JsonNode> set = Sets.newTreeSet(COMPARATOR);
            for (JsonNode element : schema.get(this.keyword)) {
                set.add(element);
            }
            return FACTORY.arrayNode().addAll(set);
        }
    }

    private static final class DivisorsSyntaxChecker
    extends AbstractSyntaxChecker {
        private static final SyntaxChecker INSTANCE = new DivisorsSyntaxChecker();

        public static SyntaxChecker getInstance() {
            return INSTANCE;
        }

        private DivisorsSyntaxChecker() {
            super("divisors", NodeType.ARRAY, new NodeType[0]);
        }

        @Override
        protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
            JsonNode node = this.getNode(tree);
            int size = node.size();
            if (size == 0) {
                report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
                return;
            }
            boolean uniqueItems = true;
            HashSet<JsonNode> set = Sets.newHashSet();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                NodeType type = NodeType.getNodeType(element);
                if (type != NodeType.INTEGER) {
                    report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("expected", NodeType.INTEGER).put("found", type));
                } else if (element.bigIntegerValue().compareTo(BigInteger.ONE) < 0) {
                    report.error(this.newMsg(tree, SyntaxMessages.INTEGER_IS_NEGATIVE).put("value", element));
                }
                uniqueItems = set.add(element);
            }
            if (!uniqueItems) {
                report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
            }
        }
    }
}

