/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.examples.ExampleBase;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.URIDownloader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;

public final class Example7
extends ExampleBase {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode good = Example7.loadResource("/fstab-good.json");
        JsonNode bad = Example7.loadResource("/fstab-bad.json");
        JsonNode bad2 = Example7.loadResource("/fstab-bad2.json");
        LoadingConfiguration cfg = LoadingConfiguration.newBuilder().addScheme("foobar", CustomDownloader.getInstance()).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema("foobar:/fstab.json#");
        ProcessingReport report = schema.validate(good);
        Example7.printReport(report);
        report = schema.validate(bad);
        Example7.printReport(report);
        report = schema.validate(bad2);
        Example7.printReport(report);
    }

    private static final class CustomDownloader
    implements URIDownloader {
        private static final String PREFIX;
        private static final URIDownloader INSTANCE;

        private CustomDownloader() {
        }

        public static URIDownloader getInstance() {
            return INSTANCE;
        }

        @Override
        public InputStream fetch(URI source) throws IOException {
            String path = PREFIX + source.getPath();
            InputStream ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                throw new IOException("resource " + path + " not found");
            }
            return ret;
        }

        static {
            INSTANCE = new CustomDownloader();
            String pkgname = CustomDownloader.class.getPackage().getName();
            PREFIX = '/' + pkgname.replace(".", "/");
        }
    }
}

