/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg;

import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.SchemaVersion;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.RefSanityChecks;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.DraftV3Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.DraftV4Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.Thawed;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

public final class ValidationConfigurationBuilder
implements Thawed<ValidationConfiguration> {
    private static final Map<SchemaVersion, Library> DEFAULT_LIBRARIES = Maps.newEnumMap(SchemaVersion.class);
    final Map<JsonRef, Library> libraries;
    Library defaultLibrary = DEFAULT_LIBRARIES.get((Object)SchemaVersion.DRAFTV4);
    boolean useFormat = true;

    ValidationConfigurationBuilder() {
        this.libraries = Maps.newHashMap();
        for (Map.Entry<SchemaVersion, Library> entry : DEFAULT_LIBRARIES.entrySet()) {
            JsonRef ref = JsonRef.fromURI(entry.getKey().getLocation());
            Library library = entry.getValue();
            this.libraries.put(ref, library);
        }
    }

    ValidationConfigurationBuilder(ValidationConfiguration cfg) {
        this.libraries = Maps.newHashMap(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
    }

    public ValidationConfigurationBuilder addLibrary(String uri, Library library) {
        JsonRef ref = RefSanityChecks.absoluteRef(uri);
        if (library == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_LIBRARY));
        }
        if (this.libraries.containsKey(ref)) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ConfigurationMessages.DUP_LIBRARY).put("uri", ref));
        }
        this.libraries.put(ref, library);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        if (version == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_VERSION));
        }
        this.defaultLibrary = DEFAULT_LIBRARIES.get((Object)version);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultLibrary(String uri, Library library) {
        this.addLibrary(uri, library);
        this.defaultLibrary = library;
        return this;
    }

    public ValidationConfigurationBuilder setUseFormat(boolean useFormat) {
        this.useFormat = useFormat;
        return this;
    }

    @Override
    public ValidationConfiguration freeze() {
        return new ValidationConfiguration(this);
    }

    static {
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV3, DraftV3Library.get());
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV4, DraftV4Library.get());
    }
}

