/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema;

import java.io.IOException;
import java.net.URI;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JsonLoader;

public enum SchemaVersion {
    DRAFTV4("http://json-schema.org/draft-04/schema#", "/draftv4/schema"),
    DRAFTV3("http://json-schema.org/draft-03/schema#", "/draftv3/schema");

    private final URI location;
    private final JsonNode schema;

    private SchemaVersion(String uri, String resource) {
        try {
            this.location = URI.create(uri);
            this.schema = JsonLoader.fromResource(resource);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public JsonNode getSchema() {
        return this.schema.deepCopy();
    }
}

