/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONObject;

public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    @Override
    public void serialize(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        this.serializeContents(jSONObject, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(jSONObject, jsonGenerator);
        this.serializeContents(jSONObject, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForObject(jSONObject, jsonGenerator);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject jSONObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            try {
                object = jSONObject.get(string);
            }
            catch (JSONException jSONException) {
                throw new JsonGenerationException(jSONException);
            }
            if (object == null || object == JSONObject.NULL) {
                if (!serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                jsonGenerator.writeNullField(string);
                continue;
            }
            jsonGenerator.writeFieldName(string);
            Class<?> clazz = object.getClass();
            if (clazz == JSONObject.class) {
                this.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == String.class) {
                jsonGenerator.writeString((String)object);
                continue;
            }
            if (clazz == Integer.class) {
                jsonGenerator.writeNumber((Integer)object);
                continue;
            }
            if (clazz == Long.class) {
                jsonGenerator.writeNumber((Long)object);
                continue;
            }
            if (clazz == Boolean.class) {
                jsonGenerator.writeBoolean((Boolean)object);
                continue;
            }
            if (clazz == Double.class) {
                jsonGenerator.writeNumber((Double)object);
                continue;
            }
            if (clazz == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                this.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                JSONArraySerializer.instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            serializerProvider.defaultSerializeValue(object, jsonGenerator);
        }
    }
}

