/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg;

import java.io.IOException;
import java.lang.reflect.Type;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.org.json.JSONObject;

public class JSONArraySerializer
extends JSONBaseSerializer<JSONArray> {
    public static final JSONArraySerializer instance = new JSONArraySerializer();

    public JSONArraySerializer() {
        super(JSONArray.class);
    }

    @Override
    public void serialize(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartArray();
        this.serializeContents(jSONArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForArray(jSONArray, jsonGenerator);
        this.serializeContents(jSONArray, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForArray(jSONArray, jsonGenerator);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            Object object = jSONArray.opt(i);
            if (object == null || object == JSONObject.NULL) {
                jsonGenerator.writeNull();
                continue;
            }
            Class<?> clazz = object.getClass();
            if (clazz == JSONObject.class) {
                JSONObjectSerializer.instance.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == JSONArray.class) {
                this.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == String.class) {
                jsonGenerator.writeString((String)object);
                continue;
            }
            if (clazz == Integer.class) {
                jsonGenerator.writeNumber((Integer)object);
                continue;
            }
            if (clazz == Long.class) {
                jsonGenerator.writeNumber((Long)object);
                continue;
            }
            if (clazz == Boolean.class) {
                jsonGenerator.writeBoolean((Boolean)object);
                continue;
            }
            if (clazz == Double.class) {
                jsonGenerator.writeNumber((Double)object);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                JSONObjectSerializer.instance.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                this.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            serializerProvider.defaultSerializeValue(object, jsonGenerator);
        }
    }
}

