/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JavaType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.annotation.NoClass;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser.SerializerFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient IdentityHashMap<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException {
        String string;
        boolean bl;
        JsonSerializer<Object> jsonSerializer;
        if (object == null) {
            jsonSerializer = this.getDefaultNullValueSerializer();
            bl = false;
        } else {
            Class<?> clazz = object.getClass();
            jsonSerializer = this.findTypedValueSerializer(clazz, true, null);
            string = this._config.getRootName();
            if (string == null) {
                bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
                if (bl) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeFieldName(this._rootNames.findRootName(object.getClass(), this._config));
                }
            } else if (string.length() == 0) {
                bl = false;
            } else {
                bl = true;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(string);
            }
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, exception);
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException, JsonGenerationException {
        boolean bl;
        JsonSerializer<Object> jsonSerializer;
        if (object == null) {
            jsonSerializer = this.getDefaultNullValueSerializer();
            bl = false;
        } else {
            if (!javaType.getRawClass().isAssignableFrom(object.getClass())) {
                this._reportIncompatibleRootType(object, javaType);
            }
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(this._rootNames.findRootName(javaType, this._config));
            }
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, exception);
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        boolean bl;
        if (object == null) {
            jsonSerializer = this.getDefaultNullValueSerializer();
            bl = false;
        } else {
            if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
                this._reportIncompatibleRootType(object, javaType);
            }
            if (jsonSerializer == null) {
                jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
            }
            if (bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(this._rootNames.findRootName(javaType, this._config));
            }
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, exception);
        }
    }

    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        JsonNode jsonNode;
        if (clazz == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        JsonSerializer<Object> jsonSerializer = this.findValueSerializer(clazz, null);
        JsonNode jsonNode2 = jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(this, null) : JsonSchema.getDefaultSchemaNode();
        if (!(jsonNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " would not be serialized as a JSON object and therefore has no schema");
        }
        return new JsonSchema((ObjectNode)jsonNode);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        jsonFormatVisitorWrapper.setProvider(this);
        this.findValueSerializer(javaType, null).acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
    }

    public boolean hasSerializerFor(Class<?> clazz) {
        try {
            return this._findExplicitUntypedSerializer(clazz) != null;
        }
        catch (JsonMappingException jsonMappingException) {
            return false;
        }
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    @Override
    public WritableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        Object object2;
        if (this._seenObjectIds == null) {
            this._seenObjectIds = new IdentityHashMap();
        } else {
            object2 = this._seenObjectIds.get(object);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int n = this._objectIdGenerators.size();
            for (int i = 0; i < n; ++i) {
                ObjectIdGenerator<?> objectIdGenerator2 = this._objectIdGenerators.get(i);
                if (!objectIdGenerator2.canUseFor(objectIdGenerator)) continue;
                object2 = objectIdGenerator2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdGenerator.newForSerialization(this);
            this._objectIdGenerators.add((ObjectIdGenerator<?>)object2);
        }
        WritableObjectId writableObjectId = new WritableObjectId((ObjectIdGenerator<?>)object2);
        this._seenObjectIds.put(object, writableObjectId);
        return writableObjectId;
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonSerializer jsonSerializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonSerializer) {
            jsonSerializer = (JsonSerializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonSerializer.None.class || clazz == NoClass.class) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonSerializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            JsonSerializer jsonSerializer2 = jsonSerializer = handlerInstantiator == null ? null : handlerInstantiator.serializerInstance(this._config, annotated, clazz);
            if (jsonSerializer == null) {
                jsonSerializer = (JsonSerializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        return this._handleResolvable(jsonSerializer);
    }

    public static final class Impl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;

        public Impl() {
        }

        protected Impl(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            super(serializerProvider, serializationConfig, serializerFactory);
        }

        @Override
        public Impl createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            return new Impl(this, serializationConfig, serializerFactory);
        }
    }
}

