/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.maven.MavenEmbedderCallable;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenInformation;
import hudson.maven.MavenRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.tools.ant.AntClassLoader;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class MavenEmbedderUtils {
    private static final String POM_PROPERTIES_PATH = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    public static final boolean debug = Boolean.getBoolean("hudson.maven.MavenEmbedderUtils.debug");

    private MavenEmbedderUtils() {
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static ClassRealm buildClassRealm(File mavenHome, ClassWorld world, ClassLoader parentClassLoader) throws MavenEmbedderException {
        if (mavenHome == null) {
            throw new IllegalArgumentException("mavenHome cannot be null");
        }
        if (!mavenHome.exists()) {
            throw new IllegalArgumentException("mavenHome '" + mavenHome.getPath() + "' doesn't seem to exist on this node (or you don't have sufficient rights to access it)");
        }
        File libDirectory = new File(mavenHome, "lib");
        if (!libDirectory.exists()) {
            throw new IllegalArgumentException(mavenHome.getPath() + " doesn't have a 'lib' subdirectory - thus cannot be a valid maven installation!");
        }
        File[] jarFiles = libDirectory.listFiles((dir, name) -> name.endsWith(".jar"));
        AntClassLoader antClassLoader = new AntClassLoader(Thread.currentThread().getContextClassLoader(), false);
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                antClassLoader.addPathComponent(jarFile);
            }
        }
        if (world == null) {
            world = new ClassWorld();
        }
        ClassRealm classRealm = new ClassRealm(world, "plexus.core", (ClassLoader)(parentClassLoader == null ? antClassLoader : parentClassLoader));
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                try {
                    classRealm.addURL(jarFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MavenEmbedderException(e.getMessage(), e);
                }
            }
        }
        return classRealm;
    }

    public static PlexusContainer buildPlexusContainer(File mavenHome, MavenRequest mavenRequest) throws MavenEmbedderException {
        ClassWorld world = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ClassRealm classRealm = MavenEmbedderUtils.buildClassRealm(mavenHome, world, Thread.currentThread().getContextClassLoader());
        DefaultContainerConfiguration conf = new DefaultContainerConfiguration();
        conf.setContainerConfigurationURL(mavenRequest.getOverridingComponentsXml()).setRealm(classRealm).setClassWorld(world).setClassPathScanning(mavenRequest.getContainerClassPathScanning()).setComponentVisibility(mavenRequest.getContainerComponentVisibility());
        return MavenEmbedderUtils.buildPlexusContainer(mavenRequest, (ContainerConfiguration)conf);
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static PlexusContainer buildPlexusContainer(ClassLoader mavenClassLoader, ClassLoader parent, MavenRequest mavenRequest) throws MavenEmbedderException {
        DefaultContainerConfiguration conf = new DefaultContainerConfiguration();
        conf.setAutoWiring(mavenRequest.isContainerAutoWiring()).setClassPathScanning(mavenRequest.getContainerClassPathScanning()).setComponentVisibility(mavenRequest.getContainerComponentVisibility()).setContainerConfigurationURL(mavenRequest.getOverridingComponentsXml());
        ClassWorld classWorld = new ClassWorld();
        ClassRealm classRealm = new ClassRealm(classWorld, "maven", mavenClassLoader);
        classRealm.setParentRealm(new ClassRealm(classWorld, "maven-parent", parent == null ? Thread.currentThread().getContextClassLoader() : parent));
        conf.setRealm(classRealm);
        conf.setClassWorld(classWorld);
        return MavenEmbedderUtils.buildPlexusContainer(mavenRequest, (ContainerConfiguration)conf);
    }

    private static PlexusContainer buildPlexusContainer(MavenRequest mavenRequest, ContainerConfiguration containerConfiguration) throws MavenEmbedderException {
        try {
            DefaultPlexusContainer plexusContainer = new DefaultPlexusContainer(containerConfiguration);
            if (mavenRequest.getMavenLoggerManager() != null) {
                plexusContainer.setLoggerManager(mavenRequest.getMavenLoggerManager());
            }
            if (mavenRequest.getLoggingLevel() > 0) {
                plexusContainer.getLoggerManager().setThreshold(mavenRequest.getLoggingLevel());
            }
            return plexusContainer;
        }
        catch (PlexusContainerException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public static MavenInformation getMavenVersion(@Nonnull File mavenHome) throws MavenEmbedderException {
        return MavenEmbedderUtils.getMavenVersion(mavenHome, null);
    }

    static MavenInformation getMavenVersion(@Nonnull File mavenHome, @CheckForNull MavenEmbedderCallable preopertiesPreloadHook) throws MavenEmbedderException {
        MavenInformation information = null;
        ClassLoader original = null;
        try {
            try (ClassRealm realm = MavenEmbedderUtils.buildClassRealm(mavenHome, null, null);){
                if (debug) {
                    MavenEmbedderUtils.debugMavenVersion(realm);
                }
                original = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)realm);
                URL resource = realm.findResource(POM_PROPERTIES_PATH);
                if (resource == null) {
                    throw new MavenEmbedderException("Couldn't find maven version information in '" + mavenHome.getPath() + "'. Are you sure that this is a valid maven home?");
                }
                URLConnection uc = resource.openConnection();
                uc.setUseCaches(false);
                try (InputStream istream = uc.getInputStream();){
                    if (preopertiesPreloadHook != null) {
                        preopertiesPreloadHook.call();
                    }
                    Properties properties = new Properties();
                    properties.load(istream);
                    information = new MavenInformation(properties.getProperty("version"), resource.toExternalForm());
                }
            }
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (IOException e) {
            try {
                throw new MavenEmbedderException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(original);
                throw throwable;
            }
        }
        return information;
    }

    public static boolean isAtLeastMavenVersion(File mavenHome, String version) throws MavenEmbedderException {
        ComparableVersion testedOne;
        ComparableVersion found = new ComparableVersion(MavenEmbedderUtils.getMavenVersion(mavenHome).getVersion());
        return found.compareTo(testedOne = new ComparableVersion(version)) >= 0;
    }

    private static void debugMavenVersion(ClassRealm realm) {
        try {
            Enumeration urls = realm.findResources(POM_PROPERTIES_PATH);
            System.out.println("urls for META-INF/maven/org.apache.maven/maven-core/pom.properties");
            while (urls.hasMoreElements()) {
                System.out.println("url " + ((URL)urls.nextElement()).toExternalForm());
            }
        }
        catch (IOException e) {
            System.out.println("Ignore IOException during searching META-INF/maven/org.apache.maven/maven-core/pom.properties:" + e.getMessage());
        }
    }
}

