/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetTag
extends TagSupport {
    private static final Log log = LogFactory.getLog(SetTag.class);
    private String var;
    private String scope;
    private Expression value;
    private Expression defaultValue;
    private Object target;
    private String property;
    private boolean encode = true;

    @Override
    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.var != null) {
            if (this.target != null || this.property != null) {
                throw new JellyTagException("The 'target' and 'property' attributes cannot be used in combination with the 'var' attribute");
            }
        } else {
            if (this.target == null) {
                throw new JellyTagException("Either a 'var' or a 'target' attribute must be defined for this tag");
            }
            if (this.property == null) {
                throw new JellyTagException("The 'target' attribute requires the 'property' attribute");
            }
        }
        Object answer = null;
        if (this.value != null) {
            answer = this.value.evaluate(this.context);
            if (this.defaultValue != null && this.isEmpty(answer)) {
                answer = this.defaultValue.evaluate(this.context);
            }
        } else {
            answer = this.getBodyText(this.isEncode());
        }
        if (this.var != null) {
            if (this.scope != null) {
                this.context.setVariable(this.var, this.scope, answer);
            } else {
                this.context.setVariable(this.var, answer);
            }
        } else {
            this.setPropertyValue(this.target, this.property, answer);
        }
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    protected void setPropertyValue(Object target, String property, Object value) {
        try {
            if (target instanceof Map) {
                Map map = (Map)target;
                map.put(property, value);
            } else {
                BeanUtils.setProperty((Object)target, (String)property, (Object)value);
            }
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Failed to set the property: " + property + " on bean: " + String.valueOf(target) + " to value: " + String.valueOf(value) + " due to exception: " + String.valueOf(e)), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Failed to set the property: " + property + " on bean: " + String.valueOf(target) + " to value: " + String.valueOf(value) + " due to exception: " + String.valueOf(e)), (Throwable)e);
        }
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            String s = (String)value;
            return s.length() == 0;
        }
        return false;
    }
}

