/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.util;

import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterGroupEntity;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ConnectionGroupVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.AppClusterClientStateWrapVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.AppClusterServerStateWrapVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterClientStateVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterServerStateVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStatePairVO;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class ClusterEntityUtils {
    public static List<AppClusterServerStateWrapVO> wrapToAppClusterServerState(List<ClusterUniversalStatePairVO> list) {
        int mode;
        if (list == null || list.isEmpty()) {
            return new ArrayList<AppClusterServerStateWrapVO>();
        }
        HashMap<String, AppClusterServerStateWrapVO> map = new HashMap<String, AppClusterServerStateWrapVO>();
        HashSet<String> tokenServerSet = new HashSet<String>();
        for (ClusterUniversalStatePairVO stateVO : list) {
            mode = stateVO.getState().getStateInfo().getMode();
            if (mode != 1) continue;
            String ip = stateVO.getIp();
            String serverId = ip + '@' + stateVO.getCommandPort();
            ClusterServerStateVO serverStateVO = stateVO.getState().getServer();
            map.computeIfAbsent(serverId, v -> new AppClusterServerStateWrapVO().setId(serverId).setIp(ip).setPort(serverStateVO.getPort()).setState(serverStateVO).setBelongToApp(true).setConnectedCount(serverStateVO.getConnection().stream().mapToInt(ConnectionGroupVO::getConnectedCount).sum()));
            tokenServerSet.add(ip + ":" + serverStateVO.getPort());
        }
        for (ClusterUniversalStatePairVO stateVO : list) {
            ClusterClientStateVO clientState;
            mode = stateVO.getState().getStateInfo().getMode();
            if (mode != 0 || (clientState = stateVO.getState().getClient()) == null) continue;
            String serverIp = clientState.getClientConfig().getServerHost();
            int serverPort = clientState.getClientConfig().getServerPort();
            if (tokenServerSet.contains(serverIp + ":" + serverPort)) continue;
            String serverId = String.format("%s:%d", serverIp, serverPort);
            map.computeIfAbsent(serverId, v -> new AppClusterServerStateWrapVO().setId(serverId).setIp(serverIp).setPort(serverPort).setBelongToApp(false));
        }
        return new ArrayList<AppClusterServerStateWrapVO>(map.values());
    }

    public static List<AppClusterClientStateWrapVO> wrapToAppClusterClientState(List<ClusterUniversalStatePairVO> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<AppClusterClientStateWrapVO>();
        }
        HashMap<String, AppClusterClientStateWrapVO> map = new HashMap<String, AppClusterClientStateWrapVO>();
        for (ClusterUniversalStatePairVO stateVO : list) {
            int mode = stateVO.getState().getStateInfo().getMode();
            if (mode != 0) continue;
            String ip = stateVO.getIp();
            String clientId = ip + '@' + stateVO.getCommandPort();
            ClusterClientStateVO clientStateVO = stateVO.getState().getClient();
            map.computeIfAbsent(clientId, v -> new AppClusterClientStateWrapVO().setId(clientId).setIp(ip).setState(clientStateVO).setCommandPort(stateVO.getCommandPort()));
        }
        return new ArrayList<AppClusterClientStateWrapVO>(map.values());
    }

    public static List<ClusterGroupEntity> wrapToClusterGroup(List<ClusterUniversalStatePairVO> list) {
        String ip;
        int mode;
        if (list == null || list.isEmpty()) {
            return new ArrayList<ClusterGroupEntity>();
        }
        HashMap<String, ClusterGroupEntity> map = new HashMap<String, ClusterGroupEntity>();
        for (ClusterUniversalStatePairVO stateVO : list) {
            mode = stateVO.getState().getStateInfo().getMode();
            ip = stateVO.getIp();
            if (mode != 1) continue;
            String serverAddress = ClusterEntityUtils.getIp(ip);
            int port = stateVO.getState().getServer().getPort();
            map.computeIfAbsent(serverAddress, v -> new ClusterGroupEntity().setBelongToApp(true).setMachineId(ip + '@' + stateVO.getCommandPort()).setIp(ip).setPort(port));
        }
        for (ClusterUniversalStatePairVO stateVO : list) {
            mode = stateVO.getState().getStateInfo().getMode();
            ip = stateVO.getIp();
            if (mode != 0) continue;
            String targetServer = stateVO.getState().getClient().getClientConfig().getServerHost();
            Integer targetPort = stateVO.getState().getClient().getClientConfig().getServerPort();
            if (StringUtil.isBlank((String)targetServer) || targetPort == null || targetPort <= 0) continue;
            ClusterGroupEntity group = map.computeIfAbsent(targetServer, v -> new ClusterGroupEntity().setBelongToApp(true).setMachineId(targetServer).setIp(targetServer).setPort(targetPort));
            group.getClientSet().add(ip + '@' + stateVO.getCommandPort());
        }
        return new ArrayList<ClusterGroupEntity>(map.values());
    }

    private static String getIp(String str) {
        if (str.contains(":")) {
            return str.split(":")[0];
        }
        return str;
    }

    private ClusterEntityUtils() {
    }
}

