/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.springfox.SwaggerJsonSerializer;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.config.mqtoken.UserTokenContext;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.PathMatcherUtil;
import org.jeecg.config.sign.interceptor.SignAuthConfiguration;
import org.jeecg.config.sign.util.HttpUtils;
import org.jeecg.config.sign.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@Configuration
public class FeignConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignConfig.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (null != attributes) {
                HttpServletRequest request = attributes.getRequest();
                log.debug("Feign request: {}", (Object)request.getRequestURI());
                String token = request.getHeader("X-Access-Token");
                if (token == null || "".equals(token)) {
                    token = request.getParameter("token");
                }
                log.debug("Feign request token: {}", (Object)token);
                requestTemplate.header("X-Access-Token", new String[]{token});
                if (PathMatcherUtil.matches(Arrays.asList(SignAuthConfiguration.urlList), (String)requestTemplate.path())) {
                    try {
                        log.info("============================ [begin] fegin starter url ============================");
                        log.info(requestTemplate.path());
                        log.info(requestTemplate.method());
                        String queryLine = requestTemplate.queryLine();
                        if (queryLine != null && queryLine.startsWith("?")) {
                            queryLine = queryLine.substring(1);
                        }
                        log.info(queryLine);
                        if (requestTemplate.body() != null) {
                            log.info(new String(requestTemplate.body()));
                        }
                        SortedMap allParams = HttpUtils.getAllParams((String)requestTemplate.path(), (String)queryLine, (byte[])requestTemplate.body(), (String)requestTemplate.method());
                        String sign = SignUtil.getParamsSign((SortedMap)allParams);
                        log.info(" Feign request params sign: {}", (Object)sign);
                        log.info("============================ [end] fegin starter url ============================");
                        requestTemplate.header("X-Sign", new String[]{sign});
                        requestTemplate.header("X-TIMESTAMP", new String[]{DateUtils.getCurrentTimestamp().toString()});
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String token = UserTokenContext.getToken();
                log.debug("Feign request token: {}", (Object)token);
                requestTemplate.header("X-Access-Token", new String[]{token});
            }
        };
    }

    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder multipartFormEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SpringFormEncoder((Encoder)new SpringEncoder(messageConverters));
    }

    @Bean
    public Encoder feignEncoder() {
        return new SpringEncoder(this.feignHttpMessageConverter());
    }

    @Bean
    public Decoder feignDecoder() {
        return new SpringDecoder(this.feignHttpMessageConverter());
    }

    private ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{this.getFastJsonConverter()});
        return () -> httpMessageConverters;
    }

    private FastJsonHttpMessageConverter getFastJsonConverter() {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        MediaType mediaTypeJson = MediaType.valueOf((String)"application/json");
        supportedMediaTypes.add(mediaTypeJson);
        converter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig config = new FastJsonConfig();
        config.getSerializeConfig().put(JSON.class, (ObjectSerializer)new SwaggerJsonSerializer());
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        converter.setFastJsonConfig(config);
        return converter;
    }
}

