/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.dtaus.spi;

import java.io.Serializable;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CurrencyCounter
implements Serializable {
    private static final long serialVersionUID = -2765988202184349786L;
    private Map currencyMap;

    public Currency[] getCurrencies() {
        HashSet<Currency> currencies = new HashSet<Currency>(this.getCurrencyMap().size());
        Iterator it = this.getCurrencyMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            currencies.add(Currency.getInstance((String)entry.getKey()));
        }
        return currencies.toArray(new Currency[currencies.size()]);
    }

    public long getValue(Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        Long value = (Long)this.getCurrencyMap().get(currency.getCurrencyCode());
        return value != null ? value : 0L;
    }

    public void add(Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        long value = this.getValue(currency);
        if (value == Long.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        this.getCurrencyMap().put(currency.getCurrencyCode(), new Long(value + 1L));
    }

    public void substract(Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        long value = this.getValue(currency);
        if (value == 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.getCurrencyMap().put(currency.getCurrencyCode(), new Long(value - 1L));
    }

    private Map getCurrencyMap() {
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap(10);
        }
        return this.currencyMap;
    }
}

