/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.input.sax;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.jdom2.JDOMException;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderSchemaFactory
implements XMLReaderJDOMFactory {
    private final SAXParserFactory saxfac;

    public XMLReaderSchemaFactory(Schema schema) {
        if (schema == null) {
            throw new NullPointerException("Cannot create a SchemaXMLReaderFactory with a null schema");
        }
        this.saxfac = SAXParserFactory.newInstance();
        this.saxfac.setNamespaceAware(true);
        this.saxfac.setValidating(false);
        this.saxfac.setSchema(schema);
    }

    public XMLReader createXMLReader() throws JDOMException {
        try {
            return this.saxfac.newSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new JDOMException("Could not create a new Schema-Validating XMLReader.", e);
        }
        catch (ParserConfigurationException e) {
            throw new JDOMException("Could not create a new Schema-Validating XMLReader.", e);
        }
    }

    public boolean isValidating() {
        return true;
    }
}

