/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.output.support;

import java.util.List;
import java.util.NoSuchElementException;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Text;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.Format;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.Walker;
import org.jdom2.util.ArrayCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormattedWalker
implements Walker {
    private final int size;
    private final List<? extends Content> content;
    private final boolean alltext;
    private final boolean allwhite;
    private final String newlineindent;
    private final String endofline;
    private final StringBuilder buffer = new StringBuilder();
    private final EscapeStrategy escape;
    private final FormatStack fstack;
    private boolean hasnext = true;
    private int cursor = 0;
    private MultiText multitext = null;
    private MultiText pendingmt = null;

    public AbstractFormattedWalker(List<? extends Content> content, FormatStack fstack, boolean doescape) {
        this.fstack = fstack;
        this.content = content;
        this.escape = doescape ? fstack.getEscapeStrategy() : null;
        this.size = content.size();
        this.newlineindent = fstack.getPadBetween();
        this.endofline = fstack.getLevelEOL();
        if (this.size == 0) {
            this.alltext = true;
            this.allwhite = true;
        } else {
            boolean atext = false;
            boolean awhite = false;
            if (this.isTextLike(0)) {
                this.pendingmt = this.buildMultiText();
                if (this.pendingmt.nextcursor >= this.size) {
                    atext = true;
                    boolean bl = awhite = this.pendingmt.msize == 0;
                }
                if (this.pendingmt.msize == 0) {
                    this.cursor = this.pendingmt.nextcursor;
                    this.pendingmt = null;
                }
            }
            this.alltext = atext;
            this.allwhite = awhite;
        }
        this.hasnext = this.cursor < this.size;
    }

    @Override
    public final Content next() {
        if (!this.hasnext) {
            throw new NoSuchElementException("Cannot walk off end of Content");
        }
        if (this.multitext != null && this.multitext.mpos + 1 >= this.multitext.msize) {
            this.cursor = this.multitext.nextcursor;
            this.multitext = null;
        }
        if (this.pendingmt != null) {
            if (this.pendingmt.wasescape != null && this.fstack.getEscapeOutput() != this.pendingmt.wasescape.booleanValue()) {
                this.pendingmt = this.buildMultiText();
            }
            this.multitext = this.pendingmt;
            this.pendingmt = null;
        }
        if (this.multitext != null) {
            this.multitext.mpos++;
            Content ret = this.multitext.returnraw[this.multitext.mpos] ? this.multitext.data[this.multitext.mpos] : null;
            this.hasnext = this.multitext.mpos + 1 < this.multitext.msize || this.multitext.nextcursor < this.size;
            return ret;
        }
        Content ret = this.content.get(this.cursor++);
        if (this.cursor >= this.size) {
            this.hasnext = false;
        } else if (this.isTextLike(this.cursor)) {
            this.pendingmt = this.buildMultiText();
            if (this.pendingmt.msize > 0) {
                this.hasnext = true;
            } else if (this.pendingmt.nextcursor < this.size && this.newlineindent != null) {
                int nc = this.pendingmt.nextcursor;
                this.pendingmt = new MultiText(nc, false, false, 1, null);
                this.pendingmt.forceAppend(this.newlineindent);
                this.pendingmt.done();
                this.hasnext = true;
            } else {
                this.pendingmt = null;
                this.hasnext = false;
            }
        } else {
            if (this.newlineindent != null) {
                this.pendingmt = new MultiText(this.cursor, false, false, 1, null);
                this.pendingmt.forceAppend(this.newlineindent);
                this.pendingmt.done();
            }
            this.hasnext = true;
        }
        return ret;
    }

    protected abstract void analyzeMultiText(MultiText var1, int var2, int var3);

    protected final Content get(int index) {
        return this.content.get(index);
    }

    @Override
    public final boolean isAllText() {
        return this.alltext;
    }

    @Override
    public final boolean hasNext() {
        return this.hasnext;
    }

    private MultiText buildMultiText() {
        int i = this.cursor - 1;
        block3: while (++i < this.size) {
            Content.CType ctype = this.content.get(i).getCType();
            switch (ctype) {
                case Text: 
                case CDATA: 
                case EntityRef: {
                    continue block3;
                }
            }
            break;
        }
        MultiText mt = new MultiText(i, this.cursor > 0, i < this.size, (i - this.cursor) * 2 + 1, this.fstack.getEscapeOutput());
        this.analyzeMultiText(mt, this.cursor, i - this.cursor);
        mt.done();
        return mt;
    }

    @Override
    public String text() {
        if (this.multitext == null || this.multitext.mpos >= this.multitext.msize) {
            return null;
        }
        if (this.multitext.returnraw[this.multitext.mpos]) {
            return null;
        }
        return this.multitext.data[this.multitext.mpos].getValue();
    }

    @Override
    public boolean isCDATA() {
        if (this.multitext == null || this.multitext.mpos >= this.multitext.msize) {
            return false;
        }
        if (this.multitext.returnraw[this.multitext.mpos]) {
            return false;
        }
        return this.multitext.data[this.multitext.mpos].getCType() == Content.CType.CDATA;
    }

    @Override
    public boolean isAllWhiteSpace() {
        return this.allwhite;
    }

    private boolean isTextLike(int pos) {
        switch (this.get(pos).getCType()) {
            case Text: 
            case CDATA: 
            case EntityRef: {
                return true;
            }
        }
        return false;
    }

    protected class MultiText {
        private final int nextcursor;
        private final boolean postpad;
        private boolean gottext = false;
        private int msize = 0;
        private Content[] data;
        private boolean[] returnraw;
        private int mpos = -1;
        private final Boolean wasescape;

        private MultiText(int nextcursor, boolean prepad, boolean postpad, int guess, Boolean wasescape) {
            this.nextcursor = nextcursor;
            this.postpad = postpad;
            this.wasescape = wasescape;
            AbstractFormattedWalker.this.buffer.setLength(0);
            if (prepad && AbstractFormattedWalker.this.newlineindent != null) {
                AbstractFormattedWalker.this.buffer.append(AbstractFormattedWalker.this.newlineindent);
            }
            this.data = new Content[guess];
            this.returnraw = new boolean[guess];
        }

        private void ensurespace() {
            if (this.msize >= this.data.length) {
                this.data = ArrayCopy.copyOf(this.data, this.msize + 4);
                this.returnraw = ArrayCopy.copyOf(this.returnraw, this.data.length);
            }
        }

        private void closeText() {
            if (AbstractFormattedWalker.this.buffer.length() == 0) {
                return;
            }
            this.ensurespace();
            this.data[this.msize++] = new Text(AbstractFormattedWalker.this.buffer.toString());
            AbstractFormattedWalker.this.buffer.setLength(0);
        }

        public void appendText(Trim trim, String text) {
            int tlen = text.length();
            if (tlen == 0) {
                return;
            }
            String toadd = null;
            switch (trim) {
                case NONE: {
                    toadd = text;
                    break;
                }
                case BOTH: {
                    toadd = Format.trimBoth(text);
                    break;
                }
                case LEFT: {
                    toadd = Format.trimLeft(text);
                    break;
                }
                case RIGHT: {
                    toadd = Format.trimRight(text);
                    break;
                }
                case COMPACT: {
                    toadd = Format.compact(text);
                }
            }
            if (toadd != null) {
                toadd = this.escapeText(toadd);
                AbstractFormattedWalker.this.buffer.append(toadd);
                this.gottext = true;
            }
        }

        private String escapeText(String text) {
            if (AbstractFormattedWalker.this.escape == null || !AbstractFormattedWalker.this.fstack.getEscapeOutput()) {
                return text;
            }
            return Format.escapeText(AbstractFormattedWalker.this.escape, AbstractFormattedWalker.this.endofline, text);
        }

        private String escapeCDATA(String text) {
            if (AbstractFormattedWalker.this.escape == null) {
                return text;
            }
            return text;
        }

        public void appendCDATA(Trim trim, String text) {
            this.closeText();
            String toadd = null;
            switch (trim) {
                case NONE: {
                    toadd = text;
                    break;
                }
                case BOTH: {
                    toadd = Format.trimBoth(text);
                    break;
                }
                case LEFT: {
                    toadd = Format.trimLeft(text);
                    break;
                }
                case RIGHT: {
                    toadd = Format.trimRight(text);
                    break;
                }
                case COMPACT: {
                    toadd = Format.compact(text);
                }
            }
            toadd = this.escapeCDATA(toadd);
            this.ensurespace();
            this.data[this.msize++] = new CDATA(toadd);
            this.gottext = true;
        }

        private void forceAppend(String text) {
            this.gottext = true;
            AbstractFormattedWalker.this.buffer.append(text);
        }

        public void appendRaw(Content c) {
            this.closeText();
            this.ensurespace();
            this.returnraw[this.msize] = true;
            this.data[this.msize++] = c;
            AbstractFormattedWalker.this.buffer.setLength(0);
        }

        public void done() {
            if (this.postpad && AbstractFormattedWalker.this.newlineindent != null) {
                AbstractFormattedWalker.this.buffer.append(AbstractFormattedWalker.this.newlineindent);
            }
            if (this.gottext) {
                this.closeText();
            }
            AbstractFormattedWalker.this.buffer.setLength(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Trim {
        LEFT,
        RIGHT,
        BOTH,
        COMPACT,
        NONE;

    }
}

