/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.output;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jdom2.IllegalDataException;
import org.jdom2.Verifier;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.LineSeparator;

public class Format
implements Cloneable {
    private static final String STANDARD_INDENT = "  ";
    private static final String STANDARD_LINE_SEPARATOR = LineSeparator.DEFAULT.value();
    private static final String STANDARD_ENCODING = "UTF-8";
    String indent = null;
    String lineSeparator = STANDARD_LINE_SEPARATOR;
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    boolean specifiedAttributesOnly = false;
    boolean expandEmptyElements = false;
    boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    EscapeStrategy escapeStrategy = new DefaultEscapeStrategy(this.encoding);

    public static Format getRawFormat() {
        return new Format();
    }

    public static Format getPrettyFormat() {
        Format f = new Format();
        f.setIndent(STANDARD_INDENT);
        f.setTextMode(TextMode.TRIM);
        return f;
    }

    public static Format getCompactFormat() {
        Format f = new Format();
        f.setTextMode(TextMode.NORMALIZE);
        return f;
    }

    public static final String compact(String str) {
        int left;
        int right = str.length() - 1;
        for (left = 0; left <= right && Verifier.isXMLWhitespace(str.charAt(left)); ++left) {
        }
        while (right > left && Verifier.isXMLWhitespace(str.charAt(right))) {
            --right;
        }
        if (left > right) {
            return "";
        }
        boolean space = true;
        StringBuilder buffer = new StringBuilder(right - left + 1);
        while (left <= right) {
            char c = str.charAt(left);
            if (Verifier.isXMLWhitespace(c)) {
                if (space) {
                    buffer.append(' ');
                    space = false;
                }
            } else {
                buffer.append(c);
                space = true;
            }
            ++left;
        }
        return buffer.toString();
    }

    public static final String trimRight(String str) {
        int right;
        for (right = str.length() - 1; right >= 0 && Verifier.isXMLWhitespace(str.charAt(right)); --right) {
        }
        if (right < 0) {
            return "";
        }
        return str.substring(0, right + 1);
    }

    public static final String trimLeft(String str) {
        int left;
        int right = str.length();
        for (left = 0; left < right && Verifier.isXMLWhitespace(str.charAt(left)); ++left) {
        }
        if (left >= right) {
            return "";
        }
        return str.substring(left);
    }

    public static final String trimBoth(String str) {
        int left;
        int right;
        for (right = str.length() - 1; right > 0 && Verifier.isXMLWhitespace(str.charAt(right)); --right) {
        }
        for (left = 0; left <= right && Verifier.isXMLWhitespace(str.charAt(left)); ++left) {
        }
        if (left > right) {
            return "";
        }
        return str.substring(left, right + 1);
    }

    public static final String escapeAttribute(EscapeStrategy strategy, String value) {
        char highsurrogate = '\u0000';
        int len = value.length();
        StringBuilder sb = new StringBuilder(len + 5);
        boolean changed = false;
        block9: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (highsurrogate > '\u0000') {
                if (!Verifier.isLowSurrogate(ch)) {
                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(highsurrogate) + " / 0x" + Integer.toHexString(ch));
                }
                int chp = Verifier.decodeSurrogatePair(highsurrogate, ch);
                sb.append("&#x");
                sb.append(Integer.toHexString(chp));
                sb.append(';');
                highsurrogate = '\u0000';
                changed = true;
                continue;
            }
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    changed = true;
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    changed = true;
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    changed = true;
                    continue block9;
                }
                case '\r': {
                    sb.append("&#xD;");
                    changed = true;
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    changed = true;
                    continue block9;
                }
                case '\t': {
                    sb.append("&#x9;");
                    changed = true;
                    continue block9;
                }
                case '\n': {
                    sb.append("&#xA;");
                    changed = true;
                    continue block9;
                }
                default: {
                    if (strategy.shouldEscape(ch)) {
                        changed = true;
                        if (Verifier.isHighSurrogate(ch)) {
                            highsurrogate = ch;
                            continue block9;
                        }
                        sb.append("&#x");
                        sb.append(Integer.toHexString(ch));
                        sb.append(';');
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        if (!changed) {
            return value;
        }
        if (highsurrogate > '\u0000') {
            throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(highsurrogate) + "truncated");
        }
        return sb.toString();
    }

    public static final String escapeText(EscapeStrategy strategy, String eol, String value) {
        int right = value.length();
        StringBuilder sb = new StringBuilder(right + 5);
        char highsurrogate = '\u0000';
        int idx = 0;
        block7: while (idx < right) {
            char ch = value.charAt(idx++);
            if (highsurrogate > '\u0000') {
                if (!Verifier.isLowSurrogate(ch)) {
                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(highsurrogate) + " / 0x" + Integer.toHexString(ch));
                }
                int chp = Verifier.decodeSurrogatePair(highsurrogate, ch);
                sb.append("&#x" + Integer.toHexString(chp) + ";");
                highsurrogate = '\u0000';
                continue;
            }
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\r': {
                    sb.append("&#xD;");
                    continue block7;
                }
                case '\n': {
                    if (eol != null) {
                        sb.append(eol);
                        continue block7;
                    }
                    sb.append('\n');
                    continue block7;
                }
            }
            if (strategy.shouldEscape(ch)) {
                if (Verifier.isHighSurrogate(ch)) {
                    highsurrogate = ch;
                    continue;
                }
                sb.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            sb.append(ch);
        }
        if (highsurrogate > '\u0000') {
            throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(highsurrogate) + "truncated");
        }
        return sb.toString();
    }

    private Format() {
    }

    public Format setEscapeStrategy(EscapeStrategy strategy) {
        this.escapeStrategy = strategy;
        return this;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public Format setLineSeparator(String separator) {
        this.lineSeparator = "".equals(separator) ? null : separator;
        return this;
    }

    public Format setLineSeparator(LineSeparator separator) {
        return this.setLineSeparator(separator == null ? STANDARD_LINE_SEPARATOR : separator.value());
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Format setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
        return this;
    }

    public boolean getOmitEncoding() {
        return this.omitEncoding;
    }

    public Format setOmitDeclaration(boolean omitDeclaration) {
        this.omitDeclaration = omitDeclaration;
        return this;
    }

    public boolean getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public Format setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
        return this;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setIgnoreTrAXEscapingPIs(boolean ignoreTrAXEscapingPIs) {
        this.ignoreTrAXEscapingPIs = ignoreTrAXEscapingPIs;
    }

    public boolean getIgnoreTrAXEscapingPIs() {
        return this.ignoreTrAXEscapingPIs;
    }

    public Format setTextMode(TextMode mode) {
        this.mode = mode;
        return this;
    }

    public TextMode getTextMode() {
        return this.mode;
    }

    public Format setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Format setEncoding(String encoding) {
        this.encoding = encoding;
        this.escapeStrategy = new DefaultEscapeStrategy(encoding);
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isSpecifiedAttributesOnly() {
        return this.specifiedAttributesOnly;
    }

    public void setSpecifiedAttributesOnly(boolean specifiedAttributesOnly) {
        this.specifiedAttributesOnly = specifiedAttributesOnly;
    }

    public Format clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextMode {
        PRESERVE,
        TRIM,
        NORMALIZE,
        TRIM_FULL_WHITE;

    }

    private static final class DefaultEscapeStrategy
    implements EscapeStrategy {
        private final int bits;
        private final CharsetEncoder encoder;

        public DefaultEscapeStrategy(String encoding) {
            if (Format.STANDARD_ENCODING.equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
                this.bits = 16;
                this.encoder = null;
            } else if ("ISO-8859-1".equalsIgnoreCase(encoding) || "Latin1".equalsIgnoreCase(encoding)) {
                this.bits = 8;
                this.encoder = null;
            } else if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
                this.bits = 7;
                this.encoder = null;
            } else {
                this.bits = 0;
                CharsetEncoder cse = null;
                try {
                    cse = Charset.forName(encoding).newEncoder();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.encoder = cse;
            }
        }

        public boolean shouldEscape(char ch) {
            if (this.bits == 16) {
                return Verifier.isHighSurrogate(ch);
            }
            if (this.bits == 8) {
                return ch > '\u00ff';
            }
            if (this.bits == 7) {
                return ch > '\u007f';
            }
            if (Verifier.isHighSurrogate(ch)) {
                return true;
            }
            if (this.encoder != null) {
                try {
                    return !this.encoder.canEncode(ch);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

